using System;
using NeonScripting;
using System.Collections;
using System.IO;
using System.Text;
using System.Linq;

public class Script
{
	public bool Run(INeonScriptHost host)
	{
		var outputFilename = host.RemoteCalls.SelectFile();
		if (outputFilename == "")
			return false;

		var sb = new StringBuilder();
		sb.AppendLine("<html>");
		sb.AppendLine("<body>");
		sb.AppendLine("<table>");
		sb.AppendLine("<tr>");
		sb.AppendLine("<th>Artist</th>");
		sb.AppendLine("<th>Title</th>");
		sb.AppendLine("<th>Album</th>");
		sb.AppendLine("<th>BPM</th>");
		sb.AppendLine("</tr>");
		var idx = 1;
		foreach(var track in host.Tracks) 
		{
			host.UpdateProgress(string.Format("File {0}", idx));
			sb.AppendLine("<tr>");
			sb.AppendFormat("<td>{0}</td>", track.Artist);
			sb.AppendLine("");
			sb.AppendFormat("<td>{0}</td>", track.Title);
			sb.AppendLine("");
			sb.AppendFormat("<td>{0}</td>", track.Album);
			sb.AppendLine("");
			var bpm = track.Bpm;
			//if (bpm <= 0)
				//bpm = host.RemoteCalls.CalculateBpm(track.FullFilename);
			sb.AppendFormat("<td>{0}</td>", bpm);
			sb.AppendLine("");
			sb.AppendLine("</tr>");
			idx++;
		}
		sb.AppendLine("</table>");
		sb.AppendLine("</body>");
		sb.AppendLine("</html>");
		
		File.WriteAllText(outputFilename, sb.ToString());
		
		return true;
	}
}