using System;
using NeonScripting;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Linq;

public class Script
{
	public bool Run(INeonScriptHost host)
	{
		var formats = new List<string>{
			"MPEG",
			"Ogg Vorbis",
			"FLAC",
			"MPEG Plus",
			"WMA",
			"AAC",
			"M4A",
			"WAVE",
			"WavPack"
		};
		var selectedFileType = host.RemoteCalls.SelectItemFromList(formats, 2);
		if (string.IsNullOrEmpty(selectedFileType))
		{
			host.RemoteCalls.ShowMessage("You must select a destination file type");
			return false;
		}
		var extension = "";
		if (selectedFileType == "MPEG")
			extension = ".mp3";
		else if (selectedFileType == "Ogg Vorbis")
			extension = ".ogg";
		else if (selectedFileType == "FLAC")
			extension = ".flac";
		else if (selectedFileType == "MPEG Plus")
			extension = ".mp+";
		else if (selectedFileType == "WMA")
			extension = ".wma";
		else if (selectedFileType == "AAC")
			extension = ".aac";
		else if (selectedFileType == "M4A")
			extension = ".m4a";
		else if (selectedFileType == "WAVE")
			extension = ".wav";
		else if (selectedFileType == "WavPack")
			extension = ".wv";
					
		var deleteFiles = true;
		var idx = 1;
		foreach(var track in host.Tracks) 
		{
			host.UpdateProgress(string.Format("File {0}", idx));
			var sourceFile = track.FullFilename;
			var destFile = Path.ChangeExtension(sourceFile, extension);
			if (File.Exists(sourceFile) && File.Exists(destFile))
			{
				host.RemoteCalls.UpdateFiletype(sourceFile, destFile);
				if (deleteFiles)
				{
					File.Delete(sourceFile);
				}
			}
			idx++;
		}
		
		return true;
	}
}