using System;
using NeonScripting;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Linq;

public class Script
{
	public bool Run(INeonScriptHost host)
	{
		var pictureFolder = host.RemoteCalls.SelectFolder();
		if (string.IsNullOrEmpty(pictureFolder))
			return true;
		 
		var pictureFiles = new List<string>();   
		foreach (var filename in Directory.GetFiles(pictureFolder, "*.*", SearchOption.AllDirectories))
		{
			var ext = Path.GetExtension(filename).ToLowerInvariant();
			if (ext == ".jpg" || ext == ".jpeg" || ext == ".png")
				pictureFiles.Add(filename);
		}
		
		var found = new List<string>();
		var artists = host.Database.Artists;
		foreach(var picture in pictureFiles)
		{
			var artistFromFile = Path.GetFileNameWithoutExtension(picture);
			host.UpdateProgress(string.Format("Updating artist picture for: {0}", artistFromFile));
			var artist = artists.FirstOrDefault(x => x.ArtistName.Equals(artistFromFile, StringComparison.InvariantCultureIgnoreCase));
			if (artist != null) 
			{
				host.Database.UpdateArtistPicture(artist, picture);
			}
		}
		
		return true;
	}

}