using System;
using NeonScripting;
using System.Collections;
using System.IO;
using System.Text;
using System.Linq;

public class Script
{
	public bool Run(INeonScriptHost host)
	{
		var total = host.Tracks.Count();
		var idx = 1;
		foreach(var track in host.Tracks) 
		{
			host.UpdateProgress(string.Format("Processing file {0}/{1}", idx, total));
			if (track.InitialKey == "") 
			{
				var key = host.RemoteCalls.CalculateMusicKey(track.FullFilename);
				track.InitialKey = key;
			}
			else
			{
				track.IgnoreChanges = true;
			}
			idx++;
		}
		host.RemoteCalls.CommitAllChanges(host.Tracks);
		
		return true;
	}

}