using System;
using NeonScripting;
using System.Collections;
using System.IO;
using System.Text;
using System.Linq;

public class Script
{
	public bool Run(INeonScriptHost host)
	{
		var albums = host.Database.Albums;
		foreach(var album in albums)
		{
			var path = album.AlbumPath;
			if (!Directory.Exists(path))
			{
				var newPath = host.Database.SuggestedAlbumPath(album, true);
				if (!path.Equals(newPath))
				{
					host.Database.UpdateAlbumPath(album, newPath);
				}
			}
		}
		return true;
	}

}