using System;
using NeonScripting;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Linq;

public class Script
{
	public bool Run(INeonScriptHost host)
	{
		var contents = new List<string>{
			"Soft house",
			"Uplifting house",
			"Progressive trance",
			"Full-on trance",
			"Uplifting trance",
			"Euro",
			"Breaks"
		};
		var res = host.RemoteCalls.SelectItemFromList(contents, 2);
		if (string.IsNullOrEmpty(res))
			return false;
		
		var idx = 1;
		foreach(var track in host.Tracks) 
		{
			host.UpdateProgress(string.Format("File {0}", idx));
			track.Custom1 = res;
			idx++;
		}
		host.RemoteCalls.CommitAllChanges(host.Tracks);
		
		return true;
	}

}