using System;
using NeonScripting;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Linq;

namespace Neon
{
	public class Script
	{
		public bool Run(INeonScriptHost host)
		{
			var collections = host.RemoteCalls.AlbumCollections;
			
			var strings = collections.Select(x => x.CollectionName).ToList();
			var selectedCollection = host.RemoteCalls.SelectItemFromList(strings, 0);
			if (!string.IsNullOrEmpty(selectedCollection))			
			{
				var collection = collections.FirstOrDefault(x => x.CollectionName.Equals(selectedCollection));
				var albums = host.Albums;
				if (albums != null)
				{
					host.RemoteCalls.AddAlbumsToCollection(albums, collection);
				}
			}
			return true;
		}

	}
}