
// 说明：二进制位运算。

var basicNumber = [
     0b10000,
     0b10000 >>  4,    // 10000 -> 00001 （0b10000，16的二进制表示法）
     16      >>  4,    //
    -16      >>  4,    // 带符号的右移动（符号位被保留了）
    -16      >>> 4,    // 不带符号的右移动（符号位被右移了4位）
     1       <<  3,    // 左位移3位  0001 -> 1000
     17      &   19,   // 二进制与，10001 & 10011 = 10001  17
     17      |   19,   // 二进制或，10001 | 10011 = 10011  19
     7       ^   3     // 异或
];

var bigNumber = [
     999999999999999999999999999999999999999999999999999999999999,
     999999999999999999999999999999999999999999999999999999999999  >>  4,    // 10000 -> 00001 （0b10000，16的二进制表示法）
     999999999999999999999999999999999999999999999999999999999999  >>  4,    //
    -999999999999999999999999999999999999999999999999999999999999  >>  4,    // 带符号的右移动（符号位被保留了）
    -999999999999999999999999999999999999999999999999999999999999  >>> 4,    // 大数模式下，效果同 >>。原因是：大数理论上可以是无限大，因此带着符号位右移动本身无意义。
     999999999999999999999999999999999999999999999999999999999999  <<  3,    // 左位移3位  0001 -> 1000
     999999999999999999999999999999999999999999999999999999999999  &   19,   // 二进制与，10001 & 10011 = 10001  17
     999999999999999999999999999999999999999999999999999999999999  |   19,   // 二进制或，10001 | 10011 = 10011  19
     999999999999999999999999999999999999999999999999999999999999  ^   3     // 异或
];

return {
    "basic"  : basicNumber,
    "big"    : bigNumber
};