/** File "zc.h"  
 *
 */

#ifndef __ZC_H_
#define __ZC_H_

/* Color maps for Q_Colorbar */

typedef enum  {
  CmapGraceGTK = 0
  ,CmapJet
  ,CmapHot
  ,CmapGrey
  ,CmapWinter
  ,CmapSpring
  ,CmapSummer
  ,CmapAutumn
  ,CmapRainbow
  ,CmapBone
  ,CmapCopper
  ,CmapOcean
  ,CmapWhite
  ,MAX_PREDEF_CMAP
} CmapPredefEnum;


typedef struct _ZCmap  ZCmap;
struct _ZCmap {
  CmapPredefEnum n;
  char name[64];
  int  ncolors;
  fRGB *map;
};

typedef enum {
  ZC_COLORBAR_NONE = 0
  ,ZC_COLORBAR_RIGHT
  ,ZC_COLORBAR_LEFT
} ZcColorbarPlace ;

void zc_cmap_set_map          (int n);
//15 void zc_cmap_set_nb_of_colors (int n);
//15 int  zc_cmap_get_nb_of_colors (int n);
char *zc_cmap_get_name        (int n);
int   zc_cmap_get_by_name     (char *s);

int  zc_init      (int gno ,int setno ,plotarr *p);
void zc_interp    (double z);
void zc_autoscale (int iobj);

void zc_colorbar_fill       (int i);
 
void zc_set_map_nxy 	    (int nx ,int ny);
void zc_draw_set_xycmap     (int gno ,int setno ,plotarr *p ,int layer);
void zc_draw_set_xycontours (int gno ,int setno);

int zc_make_current 	    (int gno_in ,int setno_in);

void zc_label_new 	    (int gno ,int setno ,double x ,double y ,double z ,double radians);
void zc_label_draw 	    (void);
int  zc_label_place	    (int gno ,int setno ,VPoint vp ,int on);
void zc_label_kill  	    (int gno ,int setno ,VPoint vp);
void zc_label_free_list     (int gno ,int setno);

#endif /*__ZC_H_  */
