/** File wavelet.h
 */


#ifndef __WAVELET_H_
#define __WAVELET_H_

#include <gsl/gsl_wavelet.h>


#ifdef WITH_GTK
void gg_wavelet_update (void);
#endif

typedef enum {
  WAVELET_DAUBECHIES
  ,WAVELET_DAUBECHIES_CENTERED
  ,WAVELET_HARR
  ,WAVELET_HARR_CENTERED
  ,WAVELET_BSPLINE
  ,WAVELET_BSPLINE_CENTERED
} WAVELET_type;

typedef struct _WAVParams WAVParams;

struct _WAVParams {
  WAVELET_type typ;        /* see above */
  int          invflag;    /* 0:forward 1:backward */
  int          stride;     /* on the input data */
  int          pk;         /* pointer to the k nb in the Bspline family */
  int          k;          /* the k number in the family */
};

void wavelet_set_defaults (void);
int  wavelet_params_get   (WAVParams *p);
int  wavelet_params_set   (WAVParams *p);

int  do_wavelet 	(int gno1 ,int setno1 ,int gno2 ,int setno2);
void do_wavelet_command (int gno1 ,int setno1 ,WAVELET_type typ ,int stride ,int k ,int invflag);


#endif /* __WAVELET_H_ */
