/**
 *  File nn_cmd_graph.c for printing graph related commands
 *  Called by ge_graph in ge_graph.c
 *   Copyright (c) 2010 P. Vincent.    See GNU GPL ../LICENCE
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "utils.h"
#include "graphs.h"
#include "graphutils.h"
#include "device.h"
#include "protos.h"
#include "nn_cmd.h"

/* Macros to simplify calls
* c: function to call, m : member of struct v: variable, f: format 
*  members  accessed via get_graph_... must be prefixed by g in local
*/
#define NCO(c,m,v,f) c(&(old->m.v)  ,g##m.v ,f)
#define NCO2(c,m,v1,v2,f) c(&(old->m.v1) ,&(old->m.v2) ,g##m.v1 ,g##m.v2 ,f)


extern void nn_cmd_prt (char *buf);

/**
 * Print commands reflecting graph parameters
 *  See  model of commands  in params.c
 */
void nn_cmd_graph (int gno ,graph *old ,int all ,int with_gno ,int undo_on)
{
  int gtype ,active ,gxscale ,gyscale;
  GLocator glocator;
  world gw;
  view gv;
  labels glabs;
  framep gf;
  char buf[1028] ,prefix[20];
  int i;
  world_stack ws;
  nn_cmd_all (all);
  nn_cmd_undo_on (undo_on);
  sprintf (prefix ,"@g%1d" ,gno); 
  nn_cmd_prefix (prefix);

  if (is_graph_active (gno)) {
    active = FALSE;        /* allways write the line below */
    nn_cmd_on_off (&active ,TRUE ,"%s on\n");
  } else {
    return;
  }
  
  nn_cmd_undo_start (with_gno ,gno);

  nn_cmd_t_f (&(old->hidden) ,is_graph_hidden (gno)  ,"%s hidden %s\n");
  gtype = get_graph_type (gno);
//044e   if (all || old->type != gtype) {
  sprintf (buf, "@g%1d type %s\n" ,gno ,graph_types (gtype));
  nn_cmd_prt (buf);
  old->type = gtype;
//044e   }
  

  nn_cmd_t_f 	(&(old->stacked) ,is_graph_stacked (gno) ,"%s stacked %s\n");
  nn_cmd_d   	(&(old->bargap)  ,get_graph_bargap (gno) ,"%s bar hgap %f\n");

  get_graph_locator (gno ,&glocator);
  NCO (nn_cmd_on_off ,locator ,pointset ,"%s fixedpoint %s\n");
  NCO (nn_cmd_i      ,locator ,pt_type  ,"%s fixedpoint type %d\n");
  NCO2 (nn_cmd_2d ,locator ,dsx ,dsy ,"%s fixedpoint xy %f, %f\n");
  if (all || old->locator.fx != glocator.fx || old->locator.fy != glocator.fy) {
    sprintf (buf, "@g%1d fixedpoint format %s %s\n" ,gno
	     ,get_format_types (glocator.fx)
	     ,get_format_types (glocator.fy));
    nn_cmd_prt (buf);
    old->locator.fx = glocator.fx;
    old->locator.fy = glocator.fy;
  }
  if (all || old->locator.px != glocator.px || old->locator.py != glocator.py) {
    sprintf (buf, "@g%1d fixedpoint prec %d, %d\n" ,gno ,glocator.px ,glocator.py);
    nn_cmd_prt (buf);
    old->locator.px = glocator.px;
    old->locator.py = glocator.py;
  }


  /*  @ With g..  commands */
  nn_cmd_prefix ("@   ");

  /*  World */
  get_graph_world (gno, &gw);
  nn_cmd_world (&(old->w) ,gw ,"%s world %.12g, %.12g, %.12g, %.12g\n");
  /* Not yet differential test for world_stack */
  for (i = 0; i < graph_world_stack_size (gno); i++) {
    get_world_stack_entry(gno, i, &ws);
    sprintf (buf, "@    stack world %.9g, %.9g, %.9g, %.9g\n", ws.w.xg1, ws.w.xg2, ws.w.yg1, ws.w.yg2);
    nn_cmd_prt (buf);
  }

  nn_cmd_d  (&(old->znorm) ,get_graph_znorm (gno) ,"%s znorm %g\n");

  /* Viewport */
  get_graph_viewport (gno, &gv);
  nn_cmd_view  (&(old->v) ,gv ,"%s view %f, %f, %f, %f\n");

  get_graph_labels (gno, &glabs);
  get_graph_titles (gno ,&(glabs.title.s) ,&(glabs.stitle.s));
  /* Title */
  NCO (nn_cmd_str  ,labs ,title.s    	 ,"%s title \"%s\"\n");
  NCO (nn_cmd_i    ,labs ,title.layer    ,"%s title layer %d\n");
  NCO (nn_cmd_font ,labs ,title.font 	 ,"%s title font %d\n");
  NCO (nn_cmd_d    ,labs ,title.charsize ,"%s title size %f\n");
  NCO (nn_cmd_i    ,labs ,title.color    ,"%s title color %d\n");
  NCO (nn_cmd_i    ,labs ,title.just     ,"%s title just %d\n");
  NCO2 (nn_cmd_2d  ,labs ,title.x1 ,title.y1 ,"%s title offset %f , %f\n");
  /* subTitle */
  NCO (nn_cmd_str  ,labs ,stitle.s    	  ,"%s subtitle \"%s\"\n");
  NCO (nn_cmd_i    ,labs ,stitle.layer    ,"%s subtitle layer %d\n");
  NCO (nn_cmd_font ,labs ,stitle.font 	  ,"%s subtitle font %d\n");
  NCO (nn_cmd_d    ,labs ,stitle.charsize ,"%s subtitle size %f\n");
  NCO (nn_cmd_i    ,labs ,stitle.color    ,"%s subtitle color %d\n");
  NCO (nn_cmd_i    ,labs ,stitle.just     ,"%s subtitle just %d\n");
  NCO2 (nn_cmd_2d  ,labs ,stitle.x1 ,stitle.y1 ,"%s subtitle offset %f , %f\n");
  /* axes scaling */
  gxscale = get_graph_xscale (gno);
  if (all || old->xscale != gxscale) {
    sprintf (buf, "@    xaxes scale %s\n" ,scale_types (gxscale));
    nn_cmd_prt (buf);
    old->xscale = gxscale;
  }
  gyscale = get_graph_yscale (gno);
  if (all || old->yscale != gyscale) {
    sprintf (buf, "@    yaxes scale %s\n" ,scale_types (gyscale));
    nn_cmd_prt (buf);
    old->yscale = gyscale;
  }
  nn_cmd_on_off (&(old->xinvert) ,is_graph_xinvert (gno) ,"%s xaxes invert %s\n");
  nn_cmd_on_off (&(old->yinvert) ,is_graph_yinvert (gno) ,"%s yaxes invert %s\n");

  /* Frame */
  get_graph_framep (gno ,&gf);
  NCO (nn_cmd_i ,f ,type             ,"%s frame type %d\n");
  NCO (nn_cmd_i ,f ,layer            ,"%s frame layer %d\n");
  NCO (nn_cmd_i ,f ,lines            ,"%s frame linestyle %d\n");
  NCO (nn_cmd_d ,f ,linew            ,"%s frame linewidth %.1f\n");
  NCO (nn_cmd_i ,f ,pen.color        ,"%s frame color %d\n");
  NCO (nn_cmd_i ,f ,pen.pattern      ,"%s frame pattern %d\n");
  NCO (nn_cmd_i ,f ,fillpen.color    ,"%s frame background color %d\n");
  NCO (nn_cmd_i ,f ,fillpen.pattern  ,"%s frame background pattern %d\n");

  /* undo/redo */
  nn_cmd_undo_end (TRUE ,gno);
}
