/**  File ng_objects.h
 *
 *   See ng_objects.c  ng_objs_draw.c
 */

#ifndef __GU_OBJECTS_H_
#define __GU_OBJECTS_H_

typedef enum {
  NO_HANDLE
  ,HANDLE_ON_CUROBJ
  ,HANDLE_ON_ALL_OBJS
} handle_enum;

typedef struct {
  double min_x ,min_y;
  double max_x ,max_y;
  double step_x ,step_y;
} SpinScaling;

/*  In ng_objects.c */

/*********** I N Q U I R Y    F U N C T I O N S  (except layers)  ***************/
int objs_max (void);
int obj_t_count (Qtype typ);
int obj_is_active   (int i);
int number_of_active_world_objs (int gno);
int obj_tid_is_valid (Qtype typ, int id);
void get_world_objs_minmax  (int gno
			     ,double *xmin, double *xmax
			     ,double *ymin, double *ymax
			     ,int *first);
int    	  obj_geom_get_num 	       (Qtype typ ,int id);
int    	  obj_tid_get_num  	       (Qtype typ ,int id ,Qtype father_typ ,int father_id);
int    	  obj_tid_get_graph_num        (int gno);
int    	  obj_tid_get_lbox_num 	       (int gno);
int    	  obj_tid_get_set_num 	       (int gno ,int setno);
void   	 *obj_tid_get_pointer 	       (Qtype typ ,int id ,int father_id);
int 	  obj_tid_is_visible_on_layer  (Qtype typ ,int id ,int father_typ ,int father_id ,int layer);
int  find_obj (VPoint vp ,int all_obj
	       ,int with_legendbox
	       ,int with_sets
	       ,int with_timestamp
	       ,int with_colorbar
	       ,view *bb ,int *gno ,int *setno);

double dist_vp_xy (VPoint vp ,double x ,double y);
int find_polyline (VPoint *vp ,int all_obj ,int id ,int *npoint ,int *num);

int find_point (int gno, VPoint *vp, int *setno, int *loc);
int arc_subtyp (int pmask);
int arc_pmask (int subtyp);
int template_pmask_get (Qtype typ);
QDobject *obj_t_get_p_to_template (Qtype typ);

int obj_t_get_template_num (Qtype typ);
int obj_t_is_geometric     (Qtype typ);
int obj_is_geom_prunable   (int i);

int  obj_get_typed_ancestor_id (int i ,Qtype typ);
int  obj_get_plotarr 	       (int i ,QDobject **ppo ,int *pgno ,int *psetno ,plotarr *p);
void obj_get_shift   	       (int i ,VPoint *vp);
int  obj_polyline_get_vp       (int i ,int n ,VPoint *vp);

/*********** C R E A T E and K I L L   F U N C T I O N S   ***************/
void obj_t_next_graph    	  (int gno);
void obj_t_next_set      	  (int gno ,int setno);
int  obj_t_next_colorbar 	  (int gno ,int setno);
int  obj_t_next_compound 	  (int *id ,int parent ,int first);
int  obj_tid_next_compound 	  (int *id ,Qtype father_typ ,int father_id ,int first);
int  obj_t_next          	  (Qtype typ ,int *id ,Qtype father_typ ,int father_id);
int  obj_tid_kill        	  (Qtype typ ,int id  ,Qtype father_typ ,int father_id);
int  obj_geom_kill       	  (Qtype typ ,int id);
void obj_polyline_kill_point  	  (int i ,int n);
int  obj_calc_spinbox_scaling 	  (int i ,SpinScaling *sp);

/*********** I N I T I A L I Z A T I O N    F U N C T I O N S   ***************/
void objs_clear (void);
void objs_t_clear (Qtype typ);
void objs_clear_graph (int gno);

/************ M A N A G E  T E M P L A T E S and  D E F A U L T S  FUNCTIONS ***************/
void obj_set_template  (QDobject *obj ,Qtype typ);
void obj_get_template  (Qtype typ ,QDobject *obj);
void obj_default_init  (void);
void set_default_arrow (Qtype typ ,Arrow *arrowp);

/*********** S E T , C O P Y   and   M O V E    F U N C T I O N S   ***************/
int  obj_duplicate 	(int i ,int *id);
void obj_set_xy12   	(int i ,VPoint vp1 ,VPoint vp2);
void obj_set_xy 	(int i ,double *x ,double *y ,int nxy);
int  obj_prune 	      	(int i ,int undo_on);
int  obj_append_child 	(int i ,int dest);

int  obj_change_loctyp  (QDobject *po ,int newloc);

void obj_scale 		(int i ,VPoint vp1 ,VPoint vp2 ,int n_handle_found);
void obj_move 	  	(int i ,VVector shift);
void obj_get  	  	(int i ,QDobject *obj);
void obj_set  	  	(int i ,QDobject *obj);
void obj_copy 	  	(QDobject *dest ,QDobject *src);
int  obj_glue     	(GList **clist);
void obj_glue_add     	(int id_compound ,int i);
int  obj_break_compound (int i);
int  obj_geom_attach_to_graph (Qtype typ ,int id ,int gno ,int delayed);
void obj_polyline_add_vpoint    (QDobject *po ,VPoint vp);
int  obj_polyline_insert_vpoint (QDobject *po ,VPoint vp ,int n);
int  obj_polyline_set_vp        (int i ,int j ,VPoint vp);
void obj_polyline_shift 	(int i ,double x ,double y);

/*********** B O U N D I N G   B O X E S   M A N A G E M E N T ************/
view obj_get_bbc    (void);
void obj_set_bbc    (int i);
void obj_update_bbc (int i ,int depth);
void obj_update_compounds_bb (void);

/*********** S E T   S T A T U S     F U N C T I O N S   ***************/
void obj_tid_make_current  (Qtype typ ,int id ,Qtype father_typ ,int father_id);
void obj_geom_make_current (Qtype typ ,int id);
void obj_make_current      (int i);

void obj_links_update (void);

/********************* L A Y E R S **********************/
void layers_init                   (void);
void layer_set 			   (int layer ,int onoff);
int  layer_is_active               (int layer);
int  layer_not_used 	  	   (int layer);
int  layer_this_set_is_not_visible (int layer ,int gno ,int setno);
int  obj_get_child_layers_minmax   (int start ,int *layer_min ,int *layer_max);
void obj_collapse_layers 	   (int start ,int layer);
void set_legend_layer 		   (int gno ,int layer);
int  get_legend_layer              (int gno);

/************ C O M P A T I B I L I T Y   F U N C T I O N S  ***************/
void errbar_to_obj (int gno ,int setno ,Errbar *errbar ,int file_project_version);

/************ O U T P U T  ***************/
int obj_polyline_write (int id , FILE *cp);

/************ U T I L I  T I E S  ***************/
void obj_errmsg (int i ,char *s);

/* In ng_objs_draw.c */
void draw_obj_handles     (int i);
void draw_typed_handles   (Qtype typ);
void draw_curobj_handles  (void);
void draw_branch_handles  (int i);
void clear_obj_handles    (int i);
void clear_typed_handles  (Qtype typ);
void clear_all_handles    (void);
int find_handle (VPoint vp ,int all_obj ,int with_strings ,VPoint *anchor_vp ,view *bb);

void scale_back           (int i ,int depth);
void draw_objs_in_graph   (int gno ,int layer);

#endif /* __GU_OBJECTS_H_  */
