#ifndef __GW_CHOICE_H__
#define __GW_CHOICE_H__

/* To avoid complicated requisition on geometry,
 * this composite widget derives from hbox but
 * it should be more logical to derive it from button
 */
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkhbox.h>

#include "gw_pannel.h"

G_BEGIN_DECLS

#define GW_CHOICE_TYPE            (gw_choice_get_type ())
#define GW_CHOICE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GW_CHOICE_TYPE, Gw_choice))
#define GW_CHOICE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GW_CHOICE_TYPE, Gw_choiceClass))
#define IS_GW_CHOICE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GW_CHOICE_TYPE))
#define IS_GW_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GW_CHOICE_TYPE))


typedef struct _Gw_choice       Gw_choice;
typedef struct _Gw_choiceClass  Gw_choiceClass;

struct _Gw_choice
{
  GtkHBox hbox;

  GtkWidget *label;
  GtkWidget *button;
  Gw_pannel **pannel;  	   /* an array of pannels */
  gint pan;            	   /* the current active pannel number */
  gint npan;           	   /* max nb of active pannels         */
  gint value;          	   /* the number of the active box in the pannel */
  gboolean  hide_on_click; /* default is TRUE */
};

struct _Gw_choiceClass
{
  GtkHBoxClass parent_class;

  void (* gw_choice) (Gw_choice *ttt);
};

GType       gw_choice_get_type      (void);
GtkWidget*  gw_choice_new           (char *label ,Gw_pannel *pannel ,int npan);

void        gw_choice_set           (Gw_choice *ttt ,gint n);

gint        gw_choice_get           (Gw_choice *ttt);
void        gw_choice_pan_set       (Gw_choice *ttt ,Gw_pannel *pannel ,int n);
void        gw_choice_hide_on_click (Gw_choice *ttt ,gboolean hide_on_click);

G_END_DECLS

#endif /* __GW_CHOICE_H__ */

