
#include <gtk/gtksignal.h>
#include <gtk/gtktogglebutton.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkdialog.h>
#include <gtk/gtkwidget.h>

#include "gw_choice.h"
#include "gw_pannel.h"

enum {
  GW_CHOICE_SIGNAL,
  LAST_SIGNAL
};


static void gw_choice_class_init          (Gw_choiceClass *klass);
static void gw_choice_init                (Gw_choice      *ttt);
static void gw_choice_clicked             (GtkWidget *button ,Gw_choice *ttt);

static guint gw_choice_signals[LAST_SIGNAL] = { 0 };

GType
gw_choice_get_type (void)
{
  static GType ttt_type = 0;

  if (!ttt_type)
    {
      static const GTypeInfo ttt_info =
      {
	sizeof (Gw_choiceClass),
	NULL, /* base_init */
        NULL, /* base_finalize */
	(GClassInitFunc) gw_choice_class_init,
        NULL, /* class_finalize */
	NULL, /* class_data */
        sizeof (Gw_choice),
	0,
	(GInstanceInitFunc) gw_choice_init,
      };

      ttt_type = g_type_register_static (GTK_TYPE_HBOX, "Gw_choice", &ttt_info, 0);
    }

  return ttt_type;
}

static void
gw_choice_class_init (Gw_choiceClass *klass)
{
  
  gw_choice_signals[GW_CHOICE_SIGNAL] = g_signal_new ("gw_choice",
					 G_TYPE_FROM_CLASS (klass),
	                                 G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION,
	                                 G_STRUCT_OFFSET (Gw_choiceClass, gw_choice),
                                         NULL, 
                                         NULL,                
					 g_cclosure_marshal_VOID__VOID,
                                         G_TYPE_NONE, 0);


}



/*  INIT */

/* Appele par gw_choice_new via g_object_new */
static void gw_choice_init (Gw_choice *ttt)
{
  //  Qu est-ce que je peux mettre ici ???????
}


GtkWidget* gw_choice_new (char *label ,Gw_pannel *pannel ,int npan)
{
  Gw_choice *ttt;

  ttt = g_object_new (GW_CHOICE_TYPE ,NULL);

  ttt->label = gtk_label_new (label);
  gtk_box_pack_start (GTK_BOX (ttt) ,ttt->label ,FALSE ,TRUE, 0);

  ttt->button = gtk_toggle_button_new_with_label ("Choose");
  gtk_box_pack_start (GTK_BOX (ttt) ,ttt->button ,FALSE ,TRUE, 1);

  /* When button is clicked, the dialog defined by pannel is run  */

  /* Declenche le dialogue */
  g_signal_connect (G_OBJECT (ttt->button) ,"toggled",
  		    G_CALLBACK (gw_choice_clicked) ,(gpointer) ttt);

  ttt->npan   = npan;
  ttt->pannel = g_malloc0 (npan * sizeof(Gw_pannel *));

  ttt->pannel[0]     = pannel;
  ttt->pan           = 0;
  ttt->hide_on_click = TRUE;

  return GTK_WIDGET (ttt);
}


/**
 * set or update element "n" in the current pannel
 */
void gw_choice_set (Gw_choice *ttt ,gint n)
{
  gint x ,y;
  const gchar *label;
  Gw_pannel *pannel = ttt->pannel[ttt->pan];

  gw_pannel_n_to_xy (pannel ,n ,&x ,&y);
  if (pannel->buttons[n] != NULL) {
    ttt->value = n;
    pannel->x_clicked = x;
    pannel->y_clicked = y;
    label = gtk_button_get_label (GTK_BUTTON(pannel->buttons[n]));
    if (label != NULL)  gtk_button_set_label (GTK_BUTTON(ttt->button) ,label);
    if (pannel->bitmaps == NULL) {
      gtk_widget_modify_bg (ttt->button ,GTK_STATE_NORMAL ,pannel->bg[n]);
      gtk_widget_modify_bg (ttt->button ,GTK_STATE_ACTIVE ,pannel->bg[n]);
    } else {
      /* sets the image into the displayed button */
      /* The line behind does not work due to GTK bug  437281
	 gtk_button_set_image (button
	 ,gtk_button_get_image (GTK_BUTTON(pannel->buttons[y][x])));
      */
      gw_pannel_bitmap_button_set (pannel ,ttt->button ,n);
    }
  }
}

gint gw_choice_get (Gw_choice *ttt)
{
  return (ttt->value);
}

/**
 * Set "pannel"  as pannel num "pan"  for ttt and makes it current
 */
void gw_choice_pan_set (Gw_choice *ttt ,Gw_pannel *pannel ,int pan)
{
  if (pan >= ttt->npan) {
    g_error ("gw_pannel_pan_set ERROR: pannel number pan=%d >= max(=%d)" ,pan ,ttt->npan);
  }
  if ( ttt->pannel[pan] == NULL) {
    g_error ("gw_pannel_pan_set ERROR: pannel nb %d not yet created." ,pan);
  }
  ttt->pannel[pan] = pannel;
  ttt->pan         = pan;
}

/**
 *  Sets "hide_on_click" switch for all the pannels
 */
void gw_choice_hide_on_click (Gw_choice *ttt ,gboolean hide_on_click)
{
  Gw_pannel *pannel;
  int i;
  if (ttt != NULL) {
    ttt->hide_on_click = hide_on_click;
    for (i = 0; i < ttt->npan; i++) {
      pannel = ttt->pannel[i];
      gw_pannel_hide_on_click (pannel ,hide_on_click);
    }
  }
}


/* Callbacks */

/** Run the pannel dialog,
 *  wait for a click on one of the buttons of the pannel
 *  then, modify the choice button accordingly
 *  and emit the "gw_choice" signal
 */
static void gw_choice_clicked (GtkWidget *button ,Gw_choice *ttt)
{
  gint x ,y ,n;
  const gchar *label;
  Gw_pannel *pannel = ttt->pannel[ttt->pan];
  
  gtk_dialog_run (GTK_DIALOG(pannel));

  x = pannel->x_clicked;
  y = pannel->y_clicked;
  ttt->value = n = gw_pannel_xy_to_n (pannel ,x ,y);
  if (pannel->buttons[n] != NULL) {
    label = gtk_button_get_label (GTK_BUTTON(pannel->buttons[n]));
    if (label != NULL)   gtk_button_set_label (GTK_BUTTON(button) ,label);
    if (pannel->bitmaps == NULL) {
      gtk_widget_modify_bg (button ,GTK_STATE_NORMAL ,pannel->bg[n]);
      gtk_widget_modify_bg (button ,GTK_STATE_ACTIVE ,pannel->bg[n]);
    } else {
    /* Does not work due to bug  437281
       gtk_button_set_image (button
       ,gtk_button_get_image (GTK_BUTTON(pannel->buttons[y][x])));
    */
      gw_pannel_bitmap_button_set (pannel ,button ,n);
    }
    g_signal_emit (G_OBJECT (ttt)  ,gw_choice_signals[GW_CHOICE_SIGNAL] ,0);
  }
}
