/**   File gg_worldwin.c 
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *   Replace worldwin.c 
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "defines.h"
#include "graphs.h"
#include "utils.h"
#include "noxprotos.h"
#include "graphutils.h"

#include "gw_list.h"
#include "gw_choice.h"

#include "gg_gtkinc.h"
#include "gg_protos.h"

static gint popup_width = 450 ,list_height = 150;
extern GdkColor  bleuciel ,wheat;

static GraphMenu3Struct *ov1_menu3   = NULL;
static GraphMenu3Struct *ov2_menu3   = NULL;
static SetsMenu3Struct  *sets_menu3  = NULL;

typedef struct _gg_Arrange_ui {
    GtkWidget *top;
    GtkWidget *graphs;
    GtkWidget *nrows;
    GtkWidget *ncols;
    GtkWidget *order;
    GtkWidget *snake;
    GtkWidget *toff;
    GtkWidget *loff;
    GtkWidget *roff;
    GtkWidget *boff;
    GtkWidget *hgap;
    GtkWidget *vgap;
    GtkWidget *hpack;
    GtkWidget *vpack;
    GtkWidget *add;
    GtkWidget *kill;
  GraphMenu3Struct *graph_menu3;
} gg_Arrange_ui;

static GtkWidget *overlay_dialog = NULL;
static GtkWidget *graph_overlay1_choice_item;
static GtkWidget *graph_overlay2_choice_item;
static GtkWidget *graph_overlaytype_item;

/**
 *  Replace  define_overlay_proc     worldwin.c   262
 */
static void gg_define_overlay_CB (GtkWidget *widget ,gint reponse)
{
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY   ) {
    int g1, g2;
    int type = gg_get_int (graph_overlaytype_item);
    
    g1 = gw_list_get_first_selected_row_num (GW_LIST (graph_overlay1_choice_item));
    g2 = gw_list_get_first_selected_row_num (GW_LIST (graph_overlay2_choice_item));
    if (g1 == g2) {
    errmsg("Can't overlay a graph onto itself");
    return;
    }
    overlay_graphs(g1, g2, type);
    gg_update_all();
    gg_drawgraph ();
  }
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (widget);
  }
}

/**
 *  Replace  create_overlay_frame     worldwin.c   290
 */
void gg_create_overlay_popup (void)
{
  GtkWidget *vb; 

  if (overlay_dialog == NULL) {
    overlay_dialog = gg_CreateAACDialog ("Overlay graphs" ,gg_define_overlay_CB ,0 ,0 ,&vb);

    graph_overlay1_choice_item = gg_CreateGraphChoice ("Overlay graph:"
						       ,GTK_SELECTION_BROWSE
						       ,popup_width ,list_height
						       ,NULL
						       ,&ov1_menu3);
    graph_overlay2_choice_item = gg_CreateGraphChoice ("Onto graph:"
						       ,GTK_SELECTION_BROWSE
						       ,popup_width ,list_height
						       ,NULL
						       ,&ov2_menu3);
    gtk_box_pack_start_defaults (GTK_BOX (vb) ,graph_overlay1_choice_item);
    gtk_box_pack_start_defaults (GTK_BOX (vb) ,graph_overlay2_choice_item);

    graph_overlaytype_item = gg_combo_new (vb ,"Smart axis hints:" ,6
						   ,"Disabled"                 	   /* GOVERLAY_SMART_AXES_DISABLED */
						   ,"X and Y axes different"   	   /* GOVERLAY_SMART_AXES_NONE */
						   ,"Same X axis scaling"      	   /* GOVERLAY_SMART_AXES_X */
						   ,"Same Y axis scaling"      	   /* GOVERLAY_SMART_AXES_Y */
						   ,"Same X and Y axis scaling");  /* GOVERLAY_SMART_AXES_XY */
  }
  gtk_widget_show_all (overlay_dialog);
}


typedef struct _gg_Auto_ui {
    GtkWidget *top;
    GtkWidget *sel;
    GtkWidget *selall;
    GtkWidget *on_item;
    GtkWidget *applyto_item;
} gg_Auto_ui;

static gg_Auto_ui aui;

/**
 *  Replace   define_autos    worldwin.c  392
 */
void gg_define_autos(int aon, int au, int ap)
{
  int i, ming, maxg;
  int cg = get_cg();

  if (au >= 0 && !is_set_active(cg, au)) {
    errmsg("Set not active");
    return;
  }
  if (ap) {
    ming = 0;
    maxg = number_of_graphs() - 1;
  } else {
    ming = cg;
    maxg = cg;
  }
  if (ming == cg && maxg == cg) {
    if (!is_graph_active(cg)) {
      errmsg("Current graph is not active!");
      return;
    }
  }
  for (i = ming; i <= maxg; i++) {
    if (is_graph_active(i)) {
      autoscale_byset(i, au, aon);
    }
  }
  gg_drawgraph();
}

/**  Service the "Use all sets" check button
 */
static void gg_set_sel_sensistive (GtkWidget *widget ,gint reponse)
{

  gtk_widget_set_sensitive (GTK_WIDGET(aui.sel)
			    ,!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)));
}

/**
 *  Replace   define_autos_proc    worldwin.c   342
 */
static void gg_define_autos_CB  (GtkWidget *widget ,gint reponse)
{
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY   ) {
    int aon, au, ap;

    aon = gg_get_int (aui.on_item);
    ap  = gg_get_int (aui.applyto_item);
    au  = gg_get_int (aui.sel);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (aui.selall))) au = -1;
    gg_define_autos(aon, au, ap);
  }
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (widget);
  }
}



/**
 *  Replace   create_autos_frame    worldwin.c  363
 */
void gg_create_autos_popup (void)
{
  GtkWidget *vb; 

  if (aui.top == NULL) {
    aui.top     = gg_CreateAACDialog ("Autoscale graphs" ,gg_define_autos_CB ,0 ,0 ,&vb);
    aui.on_item = gg_combo_new (vb ,"Autoscale:" ,5
					,"None"          /* AUTOSCALE_NONE */
					,"X"             /* AUTOSCALE_X    */
					,"Y"             /* AUTOSCALE_Y    */
					,"XY");          /* AUTOSCALE_XY   */
    gtk_combo_box_set_active (GTK_COMBO_BOX(aui.on_item) ,3);

    aui.selall 	      = gg_check_new (vb ,"Use all sets"); 
    aui.sel    	      = gg_CreateSetChoice   ("Use set:" ,GTK_SELECTION_MULTIPLE
					      ,popup_width ,list_height
					      ,NULL
					      ,&sets_menu3
					      ,NULL);
    gtk_box_pack_start_defaults (GTK_BOX (vb) ,aui.sel);
    aui.applyto_item = gg_combo_new (vb, "Apply to graph:" ,3 ,"Current" ,"All");

    g_signal_connect (aui.selall ,"toggled" ,G_CALLBACK (gg_set_sel_sensistive) ,NULL);
  }
  gtk_widget_show_all (aui.top);
}
