/* Create  "Plot appearance..." window
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *   Replace plotwin.c
 */


#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "globals.h"
#include "draw.h"
#include "utils.h"

#include "gw_pannel.h"
#include "gw_choice.h"
#include "gw_choice.h"
#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_protos.h"
#include "gg_events.h"

extern GdkColor  bleuciel ,wheat;

static GtkWidget *plot_dialog;
static GtkWidget *plot_frame ,*vb;
static GtkWidget *bg_color_item;
static GtkWidget *bg_fill_item;
static GtkWidget *timestamp_active_item;
static GtkWidget *timestamp_font_item;
static GtkWidget *timestamp_color_item;
static GtkWidget *timestamp_size_item;
static GtkWidget *timestamp_rotate_item;
static GtkWidget *timestamp_x_item;
static GtkWidget *timestamp_y_item;

static void gg_plotwin_AAC_CB (GtkWidget *w ,gint reponse);

void gg_create_plot_dialog (void)
{
  if (plot_dialog == NULL) {
    plot_dialog = gg_CreateAACDialog ("Plot appearance" ,gg_plotwin_AAC_CB ,0,0
				      ,&vb);
    plot_frame = gg_create_plot_frame (vb);
    gtk_widget_show_all (plot_frame);
  }
  gg_update_plot_items();
  gtk_widget_show_all (plot_dialog);
  gg_unset_wait_cursor();
}

GtkWidget *gg_timestamp_frame (GtkWidget *parent)
{
  GtkWidget *vbox ,*fr ,*hb;

  vbox = gg_CreateVContainer (parent);
  fr = gg_frame (vbox ,"Time stamp" ,&bleuciel ,0 ,1);
  timestamp_active_item = gg_check_new    (fr ,"Enable");
  timestamp_font_item   = gg_font_new     (fr ,"Font:");
  timestamp_color_item  = gg_color_new    (fr, "Color:");
  timestamp_size_item   = gg_charsize_new (fr, "Character size");
  timestamp_rotate_item = gg_angle_new    (fr, "Angle");

  hb = gg_CreateHContainer (fr);
  timestamp_x_item      = gg_entry_new      (hb, "X:", 10);
  timestamp_y_item      = gg_entry_new      (hb, "Y:", 10);
  return vbox;
}

/**
 *   Replace create_plot_frame    plotwin.c 63
 */
GtkWidget *gg_create_plot_frame (GtkWidget *parent)
{
  GtkWidget *vbox ,*rc;

  vbox = gg_CreateVContainer (parent);
  rc = gg_frame (vbox ,"Page background" ,&wheat ,1 ,0);
  bg_color_item = gg_color_new (rc, "Color:");
  bg_fill_item  = gg_check_new (rc ,"Fill");

  rc = gg_timestamp_frame (vbox);
  return vbox;
}

void gg_timestamp_update_xy (void)
{
  char buf[32];
  

  if (plot_frame) {
    gg_setstr_d (timestamp_x_item ,"%g", objs[0].x1 , buf);
    gg_setstr_d (timestamp_y_item ,"%g", objs[0].y1 , buf);
  }
}

void gg_timestamp_update (void)
{
  gg_set_int 		 (timestamp_active_item ,!objs[iTS].hidden);
  gg_set_int 		 (timestamp_font_item   ,objs[iTS].font);
  gg_set_int 		 (timestamp_color_item  ,objs[iTS].color);
  gg_set_dble   	 (timestamp_size_item   ,objs[iTS].charsize);
  gg_set_dble            (timestamp_rotate_item ,(double)objs[iTS].rot);
  gg_timestamp_update_xy ();
}

void gg_update_plot_items (void)
{
  gg_set_int 		 (bg_color_item         ,getbgcolor ());
  gg_set_int 		 (bg_fill_item          ,getbgfill());
  gg_timestamp_update ();
}


static void gg_plotwin_AAC_CB (GtkWidget *w ,gint reponse)
{
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY) {

    setbgcolor (gg_get_int (bg_color_item));
    setbgfill  (gg_get_int (bg_fill_item));

    objs[iTS].hidden   = !gg_get_int  (timestamp_active_item);
    objs[iTS].font     = gg_get_int   (timestamp_font_item);
    objs[iTS].color    = gg_get_int   (timestamp_color_item);    
    objs[iTS].charsize = gg_get_dble  (timestamp_size_item);    
    objs[iTS].rot = (int) gg_get_dble (timestamp_rotate_item);
    
    gg_evalexpr (timestamp_x_item, &objs[iTS].x1);
    gg_evalexpr (timestamp_y_item, &objs[iTS].y1);

    set_dirtystate ();
    gg_drawgraph ();
  }

  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (plot_dialog);
  }

}
