/* Callbacks for the examples menu */

/* Voir gg.c */
#include <gtk/gtk.h>

#include "defines.h"
#include "files.h"
#include "graphutils.h"
#include "graphs.h"
#include "utils.h"

#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_protos.h"
#include "gg_gtkinc.h"
#include "ge_protos.h"

extern void gg_initcmap (void); // Should not be here, color map management to be revised

extern void drawgraph(void);  // il semble que plotone.h ne marche pas ici

/* Protos of functions in this file  (excluded examples CB) */
int gg_load_project_file(char *fn, int as_template);
int gg_load_project(char *fn);


/** Sets the directory and call gg_load_project_file
 *  Replace load_example
 */
void gg_load_example (char *s)
{
  char buf[128];
    
  gg_set_wait_cursor();
  sprintf(buf, "examples/%s", s);
  gg_load_project_file (buf, FALSE);
  gg_drawgraph      ();
  ge_reset_explorer ();
  ge_explorer_hide  ();
  
  gg_unset_wait_cursor();
}

/**  One function for each example
 */
void ng_ex_explain_CB ()    { gg_load_example ("ng_explain.agr"); }
void ng_ex_arcs_CB ()       { gg_load_example ("ng_arcs.agr"); }
void ng_ex_import_CB ()     { gg_load_example ("ng_import.agr"); }
void ng_ex_spline_CB ()     { gg_load_example ("ng_spline.agr"); }
void ng_ex_follow_me_CB ()  { gg_load_example ("ng_follow_me.agr"); }
void ng_ex_diode_CB ()      { gg_load_example ("ng_diode.agr"); }
void ng_ex_fourier_CB ()    { gg_load_example ("ng_fourier.agr"); }
void ng_ex_fourier2_CB ()   { gg_load_example ("ng_fourier2.agr"); }
void ng_ex_spectrum2_CB ()  { gg_load_example ("ng_spectrum2.agr"); }
void ng_ex_xycmap_CB  ()    { gg_load_example ("ng_xycmap.agr"); }
void ng_ex_xyspline_CB  ()  { gg_load_example ("ng_xyspline.agr"); }
void ng_ex_xyvmap_CB  ()    { gg_load_example ("ng_xyvmap.agr"); }
void ng_ex_nonnlb_CB  ()    { gg_load_example ("ng_nonlfitb.agr"); }
void ng_ex_nonnli_CB  ()    { 
  gg_load_example      ("ng_nonlfit.agr");
  gg_create_nonl_popup (NULL ,NULL);
}
void ng_ex_polar2_CB  ()    { gg_load_example ("ng_polar2.agr"); }
void ng_ex_reciprocal2_CB () { gg_load_example ("ng_reciprocal.agr"); }
void ng_ex_wavelet_CB ()    { gg_load_example ("ng_wavelet.agr"); }
void ng_ex_waveletb_CB ()   { gg_load_example ("ng_waveletb.agr"); }
void ng_ex_mixed_CB   ()    { gg_load_example ("ng_mixed.agr"); }


void gg_ex_explain_CB ()    { gg_load_example ("explain.agr"); }
void gg_ex_properties_CB () { gg_load_example ("props.agr"); }
void gg_ex_axes_CB ()       { gg_load_example ("axes.agr"); }
void gg_ex_fonts_CB ()      { gg_load_example ("tfonts.agr"); }
void gg_ex_arrows_CB ()     { gg_load_example ("arrows.agr"); }
void gg_ex_symslines_CB ()  { gg_load_example ("symslines.agr"); }
void gg_ex_fills_CB ()      { gg_load_example ("fills.agr"); }
void gg_ex_world_CB ()      { gg_load_example ("tstack.agr"); }
void gg_ex_tinset_CB ()     { gg_load_example ("tinset.agr"); }
void gg_ex_manygraphs_CB () { gg_load_example ("manygraphs.agr"); }
void gg_ex_tlog_CB ()       { gg_load_example ("tlog.agr"); }
void gg_ex_log2_CB ()       { gg_load_example ("log2.agr"); }
void gg_ex_log2log_CB ()    { gg_load_example ("log2log.agr"); }
void gg_ex_logit_CB ()      { gg_load_example ("logit.agr"); }
void gg_ex_reciprocal_CB () { gg_load_example ("reciprocal.agr"); }
void gg_ex_terr_CB ()       { gg_load_example ("terr.agr"); }
void gg_ex_times_CB ()      { gg_load_example ("times.agr"); }
void gg_ex_au_CB ()         { gg_load_example ("au.agr"); }
void gg_ex_co2_CB ()        { gg_load_example ("co2.agr"); }
void gg_ex_motif_CB ()      { gg_load_example ("motif.agr"); }
void gg_ex_spectrum_CB ()   { gg_load_example ("spectrum.agr"); }


void gg_ex_bar_CB ()        { gg_load_example ("bar.agr"); }
void gg_ex_stackedb_CB ()   { gg_load_example ("stackedb.agr"); }
void gg_ex_chartebar_CB ()  { gg_load_example ("chartebar.agr"); }
void gg_ex_charts_CB ()     { gg_load_example ("charts.agr"); }

void gg_ex_polar_CB ()      { gg_load_example ("polar.agr"); }

void gg_ex_pie_CB ()        { gg_load_example ("pie.agr"); }

void gg_ex_hilo_CB     ()   { gg_load_example ("hilo.agr"); }
void gg_ex_txyr_CB     ()   { gg_load_example ("txyr.agr"); }
void gg_ex_xyz_CB      ()   { gg_load_example ("xyz.agr"); }
void gg_ex_boxplot_CB  ()   { gg_load_example ("boxplot.agr"); }
void gg_ex_vmap_CB     ()   { gg_load_example ("vmap.agr"); }
void gg_ex_xysize_CB   ()   { gg_load_example ("xysize.agr"); }
void gg_ex_xycolor_CB  ()   { gg_load_example ("xycolor.agr"); }

void gg_ex_test2_CB ()      { gg_load_example ("test2.agr"); }
void gg_ex_txttrans_CB ()   { gg_load_example ("txttrans.agr"); }
void gg_ex_typeset_CB ()    { gg_load_example ("typeset.agr"); }

void gg_ex_logistic_CB ()   { gg_load_example ("logistic.agr"); }

void gg_ex_essai_CB    ()   { gg_load_example ("ESSAI.agr"); }

/*
void gg_ex__CB () { load_example (".agr"); }
*/

/**
 * gg_load_project_file
 *   Replace load_project_file    files.c   1092
 */
int gg_load_project_file (char *fn, int as_template)
{    
    int gno;
    int retval;
    
    if (wipeout () ) {
	return RETURN_FAILURE;
    } else {

      //      free (gg_colors);                                   // <<<<<<<<<<<<<<<
      //      gg_colors = malloc (MAXCOLORS * sizeof (GdkColor)); // <<<<<<<<<<<<<<<
      gg_initcmap ();

        if (getdata(0, fn, SOURCE_DISK, LOAD_SINGLE) == RETURN_SUCCESS) {
            if (as_template == FALSE) {
                set_docname(fn);
            }
            clear_dirtystate();
            retval = RETURN_SUCCESS;
        } else {
 	    retval = RETURN_FAILURE;
        }

	/* try to switch to the first active graph */
	for (gno = 0; gno < number_of_graphs(); gno++) {
	  if (is_graph_hidden(gno) == FALSE) {
	    select_graph (gno);
	    break;
	  }
	}

#ifndef NONE_GUI
   	gg_update_all    ();
	ge_obj_reset_rpane_obj_num ();
#endif
        return retval;
    }
}

int gg_load_project (char *fn)
{
  return gg_load_project_file (fn, FALSE);
}
