/**
 *  File template.h
 */

#ifndef __TEMPLATE_H_
#define __TEMPLATE_H_

#include "device.h"
#include "t1fonts.h"
#include "draw.h"
#include "defines.h"
#include "graphs.h"

typedef struct _Template {
  int version;
  int wpp ,hpp;    	     /* page size             */
  double scrollper;    	     /* page scroll  (global) */
  double shexper;      	     /* page inout   (global) */
  int scrolling_islinked;    /* link page    (global) */
  int nfonts;                /*               utility */
  FontDB     *fonts;         /* map font              */
  int ncolors;               /*               utility */
  CMap_entry *cmap;          /* map color             */
  double ref_date;           /* reference date        */
  int two_digits_years_flag; /* date wrap             */
  int wrap_year;             /* date wrap year        */
  defaults grdefaults;       /* linew, lines, color, pattern,
				font, charsize, symsize */
  graph *gr;
  char *sformat;             /* sformat      (global) */
  int bgcolor;               /* background color      */
  int bgfill;                /* page background fill  */
  QDobject timestamp;
  QDobject objs[Q_Last];
  region rg;
  int xscale  ,yscale;
  int xinvert ,yinvert;  /*  (SHOULD BE in tickmarks ?) */
  tickmarks *tmarks;
  legend l;
  plotarr p;
} Template;

Template *template_set (Template *tp);

#endif /*__TEMPLATE_H_ */

