/**
 *  File nn_cmd_legendbox.c for printing legendbox related commands
 *  Called by ge_legendbox_apply in ge_legendbox.c
 *   Copyright (c) 2010 P. Vincent.    See GNU GPL ../LICENCE
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "ng_objects.h"

#include "nn_cmd.h"

extern void gg_cmd_prt (char *buf);

/* c: function to call, v: variable, f: format */
#define NC1(c,v,f) c(&(old->v) ,l.v ,f)
#define NC2(c,v1,v2,f) c(&(old->v1) ,&(old->v2) ,l.v1 ,l.v2 ,f)

/**
 * Print commands reflecting legendbox parameters
 *  See params.c
 */
void nn_cmd_legendbox (int gno ,legend *old ,QDobject *oobj ,int all ,int undo_on)
{
  legend l;
  QDobject lobj;
  char prefix[30];

  nn_cmd_undo_on    (undo_on);
  nn_cmd_all 	    (all);
  nn_cmd_undo_start (FALSE ,-1); 

  sprintf (prefix ,"@  Legend G%d " ,gno);
  nn_cmd_prefix (prefix);

  get_graph_legend (gno , &l ,&lobj);

  NC1 (nn_cmd_on_off ,active           ,"%s %s\n");
  nn_cmd_i (&(oobj->layer) ,lobj.layer ,"%s layer %d\n");
  NC1 (nn_cmd_w_v  ,loctype            ,"%s loctype %s\n");
  NC2 (nn_cmd_2d   ,legx ,legy         ,"%s %.12g, %.12g\n");    
  NC1 (nn_cmd_i    ,boxpen.color       ,"%s box color %d\n");
  NC1 (nn_cmd_i    ,boxpen.pattern     ,"%s box pattern %d\n");
  NC1 (nn_cmd_d    ,boxlinew           ,"%s box linewidth %.1f\n");
  NC1 (nn_cmd_i    ,boxlines           ,"%s box linestyle %d\n");
  NC1 (nn_cmd_i    ,boxfillpen.color   ,"%s box fill color %d\n");
  NC1 (nn_cmd_i    ,boxfillpen.pattern ,"%s box fill pattern %d\n");
  NC1 (nn_cmd_font ,font               ,"%s font %d\n");
  NC1 (nn_cmd_d    ,charsize           ,"%s char size %f\n");
  NC1 (nn_cmd_i    ,color              ,"%s color %d\n");
  NC1 (nn_cmd_i    ,len                ,"%s length %d\n");
  NC1 (nn_cmd_i    ,vgap               ,"%s vgap %d\n");
  NC1 (nn_cmd_i    ,hgap               ,"%s hgap %d\n");
  NC1 (nn_cmd_t_f  ,invert             ,"%s invert %s\n");

  /* undo/redo */
  if (undo_on) nn_cmd_undo_end (FALSE ,-1);
}
