/** File gg_protos.h
 *  Replace xprotos.h
 */


#ifndef __GG_PROTOS_H_
#define __GG_PROTOS_H_

#include "gg_frame.h"

void set_pagelayout(int layout);  // should be gg_set_pagelayout

int gg_initialize_gui(int *argc, char **argv);

GdkDrawable *gg_get_win (void);  //17 

void gg_drawgraph    (void);
void gg_drawgraph_CB (GtkWidget *w ,gpointer p);

gboolean gg_expose_resize_CB (GtkWidget *w ,GdkEventExpose *event, gpointer data);

void gg_select_line 	     (int x1 ,int y1 ,int x2 ,int y2 ,int erase);
void gg_select_2lines 	     (int x1, int y1, int x2, int y2, int x3, int y3, int erase);
void gg_select_region 	     (int x1 ,int y1 ,int x2 ,int y2 ,int erase);
void gg_select_region_scale  (int x1 ,int y1 ,int x2 ,int y2 ,int erase ,int pmask);
void gg_get_cur_square       (int pmask ,VPoint *vp1 ,VPoint *vp2);
void gg_slide_region (view bbox ,int shift_x ,int shift_y ,int erase ,int center);
void gg_reset_crosshair (void);
void gg_crosshair_motion (int x ,int y);

void gg_select_region_or_line  (Qtype typ ,int x1, int y1, int x2, int y2, int erase);

void gg_new_CB (void);
void gg_open_project_popup   	(void);
void gg_save_CB              	(void);
void gg_saveas_CB            	(void);
void gg_import_popup         	(GtkWidget *w ,gpointer p);
void gg_revert_to_saved_CB      (GtkWidget *w ,gpointer p);


void gg_print_version_CB     	(void);
void gg_to_be_done_CB        	(GtkWidget *w ,gpointer p);
void gg_create_page_setup_CB 	(GtkWidget *w ,gpointer p);
void gg_create_printer_setup_CB (GtkWidget *w ,gpointer p);
void gg_create_printer_setup    (int device);
void gg_do_print_CB             (GtkWidget *w ,gpointer p);
void gg_set_orient              (int orientation);


void gg_update_bt_graph    (void);
void gg_update_layers_hbox (void);
void gg_layer_set 	   (int layer ,int onoff);

GtkWidget *gg_timestamp_frame     (GtkWidget *parent);
void 	   gg_timestamp_update_xy (void);
void 	   gg_timestamp_update    (void);

void gg_string_edit_update_xy (double x ,double y);
void gg_string_edit_popup  (int stringno);
void gg_line_edit_popup    (int lineno);
void gg_box_edit_popup     (int boxno);
void gg_ellipse_edit_popup (int boxno);
/*
 */
void gg_undo_CB       	(GtkWidget *w_undo ,gpointer p);
void gg_redo_CB       	(GtkWidget *w_redo ,gpointer p);
void gg_undo_update     (int undo_count ,int redo_count);

void gg_status_message (char *s);            /* xprotos.h 44 */

void gg_draw_rect  (VPoint vp);

void gg_switch_current_graph (int gno);       /* xprotos.h 58 */
void gg_switch_current_set   (int gno ,int setno);

void gg_unregister_rti (GIOChannel *channel); /* xprotos.h 62 */
void gg_Xregister_rti (Input_buffer *ib);     /* xprotos.h 63 */

void gg_create_rparams_CB (GtkWidget *w ,gpointer p); /* xprotos.h 69 */
void gg_create_wparams_CB (GtkWidget *w ,gpointer p); /* xprotos.h 70 */

void gg_eblock_create_frame (int gno);        /* xprotos.h 75 */

void gg_create_command_popup (void);          /* xprotos.h 79 */

GtkWidget *gg_fontwin_create	    (GtkWidget *w ,gpointer p);
void 	   gg_fontwin_set_cur_entry (GtkWidget *entry);

void gg_create_eval_popup (void);             /* xprotos.h 81 */

void gg_fourier_create_win (GtkWidget *w ,gpointer p);
void gg_wavelet_create_win (GtkWidget *w ,gpointer p);

void gg_create_histo_popup (void);            /* xprotos.h 83 */
void gg_create_fourier_popup (void);          /* xprotos.h 84 */
void gg_create_run_popup (void);              /* xprotos.h 85 */
void gg_create_reg_popup (void);              /* xprotos.h 86 */

void gg_diff_create_win  (void);
void gg_diff_update      (void);

void gg_create_seasonal_popup (void);         /* xprotos.h 88 */
void gg_create_interp_popup (void);           /* xprotos.h 89 */
void gg_create_int_popup (void);              /* xprotos.h 90 */
void gg_create_xcor_popup (void);             /* xprotos.h 91 */
void gg_create_samp_popup (void);             /* xprotos.h 92 */
void gg_create_prune_popup (void);            /* xprotos.h 93 */
void gg_create_digf_popup (void);             /* xprotos.h 94 */
void gg_create_lconv_popup (void);            /* xprotos.h 95 */
void gg_create_leval_frame (int gno);         /* xprotos.h 96 */
void gg_create_geom_popup (void);             /* xprotos.h 97 */

void gg_create_write_popup    (void);         /* xprotos.h 99 */
void gg_create_hotlinks_popup (void);         /* xprotos.h 100 */

void gg_create_regiondef_popup (void);        /* xprotos.h 107 */
void gg_create_regionclear_popup (void);      /* xprotos.h 108 */
void gg_create_reporton_popup (void);         /* xprotos.h 109 */

void gg_define_region (int nr, int rtype);    /* xprotos.h 112 */
void gg_define_status_popup (void);           /* xprotos.h 114 */

void gg_create_overlay_popup  (void);         /* xprotos.h 133 */
void gg_create_autos_popup    (void);         /* xprotos.h 134 */
void gg_create_setop_popup_CB (GtkWidget *w ,gpointer p);

void gg_define_objects_CB ();                 /* xprotos.h 136 */

void gg_update_locator_items (int gno);       /* xprotos.h 138 */
void gg_create_locator_frame ();              /* xprotos.h 139 */

void gg_create_monitor_frame 	(int force, char *msg);
void gg_create_monitor_frame_CB (GtkWidget w ,gpointer p); /* xprotos.h 144 */
void gg_stufftextwin 		(char *msg);               /* xprotos.h 145 */

void gg_HelpCB (gpointer p);                  /* xprotos.h 147 */

void gg_create_nonl_popup (GtkWidget *w ,gpointer p); /* xprotos.h 149 */
void gg_nonl_update       (void);

void gg_create_plot_dialog (void);             /* xprotos.h 154 */
GtkWidget *gg_create_plot_frame (GtkWidget *parent);
void gg_update_plot_items (void);

void gg_create_props_frame (void);            /* xprotos.h 156 */

void gg_set_cursor (int c);                   /* xprotos.h 163 */
void gg_init_cursors (void);                  /* xprotos.h 164 */

gint gg_get_depth (void);
int gg_init_option_menus (void);              /* xprotos.h 165 */

int gg_object_edit_popup (int type ,int id);  /* xprotos.h 173 */

void gg_errwin (const char *msg);             /* xprotos.h 180 */

void gg_create_datasetprop_popup  (void);     /* xprotos.h 182 */
void gg_create_datasetop_popup 	  (void);     /* xprotos.h 183 */
void gg_create_datasetop_popup_CB (GtkWidget *w ,gpointer p);
void gg_create_setop_popup (void);            /* xprotos.h 184 */

void gg_create_featext_popup (void);          /* xprotos.h 186 */

void gg_do_ext_editor (int gno, int setno);   /* xprotos.h 190 */

void gg_update_props_items(void);             /* xprotos.h 194 */

void set_barebones (int onoff);               /* xprotos.h 198 */


GtkWidget *gg_CreateTextItem2  (GtkWidget *parent ,char *s ,int len);

GtkTextBuffer *gg_CreateScrollTextItem2 (GtkWidget *parent
					 ,int width , int height
					 ,char *s);
void gg_setstr    (GtkWidget *w, char *s);
void gg_set_utf8  (GtkWidget *w, char *s);
void gg_setstr_d  (GtkWidget *w, char *fmt ,double d ,char *buf);
void gg_setstr_2d (GtkWidget *w1 ,GtkWidget *w2 ,double d1 ,double d2);

GtkWidget *gg_CreateVContainer (GtkWidget * parent);
GtkWidget *gg_CreateHContainer (GtkWidget * parent);

GtkWidget *gg_CreateAACDialog (gchar *title
				,void (*cbproc) (GtkWidget *w ,gint reponse)
				,gint width ,gint height
				,GtkWidget **vb);

gboolean gg_ask_expr 	  (char *msg ,char *title ,int len ,double *d);

GtkWidget *vpg_frame 	  (GtkWidget *parent ,gchar *label ,GdkColor *couleur);
GtkWidget *gg_Createframe (GtkWidget *parent ,gchar *label
			   ,GdkColor *couleur ,int nx ,int ny);

GtkWidget *gg_Create2VBox (GtkWidget *parent ,gchar *label ,GdkColor *couleur
			   ,GtkWidget **lbox ,GtkWidget **rbox);

void gg_void_cell (GtkWidget *parent);


void gg_fileswin_update_selxy (void);
char *get_default_sel_string (int gnotyp);

void gg_update_all(void);

/* gg_examplescb.c */
void ng_ex_explain_CB ()    ;
void ng_ex_arcs_CB ()       ;
void ng_ex_import_CB ()     ;
void ng_ex_spline_CB ()     ;
void ng_ex_xyspline_CB ()     ;
void ng_ex_follow_me_CB ()  ;
void ng_ex_diode_CB     ()  ;
void ng_ex_fourier_CB ()    ;
void ng_ex_fourier2_CB ()   ;
void ng_ex_spectrum2_CB ()  ;
void ng_ex_xycmap_CB ()     ;
void ng_ex_xyvmap_CB ()     ;
void ng_ex_nonnlb_CB  ()    ;
void ng_ex_nonnli_CB  ()    ;
void ng_ex_polar2_CB  ()    ;
void ng_ex_reciprocal2_CB ();
void ng_ex_wavelet_CB ()    ;
void ng_ex_waveletb_CB ()   ;
void ng_ex_mixed_CB   ()    ;

void gg_ex_explain_CB ()    ;
void gg_ex_properties_CB () ;
void gg_ex_axes_CB ()       ;
void gg_ex_fonts_CB ()      ;
void gg_ex_arrows_CB ()     ;
void gg_ex_symslines_CB ()  ;
void gg_ex_fills_CB ()      ;
void gg_ex_world_CB ()      ;
void gg_ex_tinset_CB ()     ;
void gg_ex_manygraphs_CB () ;
void gg_ex_tlog_CB ()       ;
void gg_ex_log2_CB ()       ;
void gg_ex_log2log_CB ()    ;
void gg_ex_logit_CB ()      ;
void gg_ex_reciprocal_CB () ;
void gg_ex_terr_CB ()       ;
void gg_ex_times_CB ()      ;
void gg_ex_au_CB ()         ;
void gg_ex_co2_CB ()        ;
void gg_ex_motif_CB ()      ;
void gg_ex_spectrum_CB ()   ;

void gg_ex_bar_CB ()        ;
void gg_ex_stackedb_CB ()   ;
void gg_ex_chartebar_CB ()  ;
void gg_ex_charts_CB ()     ;

void gg_ex_polar_CB ()      ;

void gg_ex_pie_CB ()        ;

void gg_ex_hilo_CB     ()   ;
void gg_ex_txyr_CB     ()   ;
void gg_ex_xyz_CB      ()   ;
void gg_ex_boxplot_CB  ()   ;
void gg_ex_vmap_CB     ()   ;
void gg_ex_xysize_CB   ()   ;
void gg_ex_xycolor_CB  ()   ;

void gg_ex_test2_CB ()      ;
void gg_ex_txttrans_CB ()   ;
void gg_ex_typeset_CB ()    ;

void gg_ex_logistic_CB ()   ;

void gg_ex_essai_CB ()   ;

#endif /* __GG_PROTOS_H_ */
