/* File gg_events.h   See events.h */

#ifndef __GG_EVENTS_H_
#define __GG_EVENTS_H_

/* for canvas event proc */
/* Synchronize with SetActionType and Button1_Pressed in gg_events.c */
typedef enum {
  DO_NOTHING    
  ,ZOOM_1ST      
  ,ZOOM_2ND      
  ,ZOOMX_1ST     
  ,ZOOMX_2ND     
  ,ZOOMY_1ST     
  ,ZOOMY_2ND     
  ,VIEW_1ST      
  ,VIEW_2ND      
  ,EDIT_OBJ
  ,DEL_OBJ
  ,MOVE_OBJ_1ST
  ,COPY_OBJ_1ST
  ,MAKE_OBJ_1ST
  ,SCALE_OBJ_1ST
  ,MOVE_OBJ_2ND
  ,COPY_OBJ_2ND
  ,MAKE_OBJ_2ND
  ,MAKE_POLYLINE
  ,SCALE_OBJ_2ND
  ,AUTO_NEAREST
  ,DEL_POINT     
  ,MOVE_POINT1ST 
  ,MOVX_POINT1ST 
  ,MOVY_POINT1ST 
  ,MOVE_POINT2ND 
  ,ADD_POINT_1ST
  ,ADD_POINT_2ND  
  ,SEL_POINT     
  ,DEF_REGION1ST 
  ,DEF_REGION2ND 
  ,DEF_REGION    
  ,GLUE_OBJS_1ST
  ,GLUE_OBJS_2ND
  ,BREAK_COMPOUND
  ,PEAK_POS
  ,PEAK_POS1
  ,PEAK_POS2
  ,PEAK_POS1B
  ,PEAK_POS2B
  ,PEAK_POS3B
  ,PLACE_LABEL
  ,KILL_LABEL
  ,COMP_AREA     
  ,COMP_PERIMETER
  ,DISLINE1ST    
  ,DISLINE2ND 
} CanvasActionFlag;


typedef struct {
  CanvasActionFlag act;                    
  int cursor;
  char *message1;
  char *message2;
} SetActionType;

typedef struct {
  CanvasActionFlag a1;   /* the flag of the action to be performed  */
  CanvasActionFlag a2;   /* the flag of the next action to be set */
  int order;             /* 12: perform a1 then set a2
			    21: set a2 then perform a1 */
  int (* fun) (int p1);  /* the function to perform the action
			    retuns TRUE is successful */
  int p1;                /* an argument for fun */
} BtActionType;

typedef struct {
  int key;
  int modifier;
  int action;
  Qtype typ;
} ShortcutType;

typedef enum {
  Button1  = 1
  ,Button2 = 2
  ,Button3 = 3
} MouseButtonType ;

/* add points at */
#define ADD_POINT_BEGINNING 0
#define ADD_POINT_END       1
#define ADD_POINT_NEAREST   2

/* move points */
#define MOVE_POINT_XY   3
#define MOVE_POINT_X    4
#define MOVE_POINT_Y    5


#define CLICKINT 400

#define MAXPICKDIST 0.015      /* the maximum distance away from an object */
                              /* you may be when picking it (in viewport  */
                              /* coordinates)                             */  
 

void gg_myproc (GtkWidget *widget, GdkEvent *event, gpointer data);     /* events.h 107 */

void gg_act_on_cur_obj_CB (GtkWidget *widget ,gpointer p);
void gg_make_obj_CB       (GtkWidget *widget ,gpointer p);
void gg_set_action_CB     (GtkWidget *widget ,gpointer p); 
void gg_set_action           (CanvasActionFlag act);   
void gg_clear_and_set_action (CanvasActionFlag act);

void gg_track_point (int gno, int setno, int *loc, int shift);          /* events.h 110 */
void gg_getpoints (VPoint *vpp);                                        /* events.h 111 */
void gg_set_stack_message (void);                                       /* events.h 112 */

void gg_do_select_region (void);                                        /* events.h 116 */
int gg_next_graph_containing (int cg, VPoint vp);                       /* events.h 117 */

int gg_graph_clicked(int gno, VPoint vp);
int gg_focus_clicked(int cg, VPoint vp, VPoint *avp);
int gg_legend_clicked(int gno, VPoint vp, view *bb);
int gg_axis_clicked(int gno, VPoint vp, int *axisno);
int gg_title_clicked(int gno, VPoint vp);
int gg_find_insert_location(int gno, int setno, VPoint vp);
int gg_find_point(int gno, VPoint vp, int *setno, int *loc);
void gg_newworld (int gno, int axes, VPoint vp1, VPoint vp2);

/* action routines */

void gg_update_point_locator (int gno, int setno, int loc);           /* events.h 145 */

void gg_place_legend_action (void);
void gg_move_this_object   (int typ ,int id);
void gg_copy_this_object   (int typ ,int id);
void gg_delete_this_object (int typ ,int id);

#endif /* __GG_EVENTS_H_ */
