/**   File gg.c
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *  Replace xmgrace.c
 * Grace - GRaphing, Advanced Computation and Exploration of data
 *
 * Home page: http://plasma-gate.weizmann.ac.il/Grace/
 *
 * Copyright (c) 1991-1995 Paul J Turner, Portland, OR
 * Copyright (c) 1996-2003 Grace Development Team
 */

#define _GG_
#define _NEED_CUPS_

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "draw.h"     /* pour bg_white et bg_black  A REVOIR*/
#include "globals.h"
#include "utils.h"
#include "graphutils.h"
#include "noxprotos.h"
#include "files.h"
#include "bitmaps.h"

#ifdef HAVE_CUPS
#include "device.h"
#endif /* HAVE_CUPS */
#include "gw_list.h"

#include "gg_gtkinc.h"
#include "gg_gtkdrv.h"
#include "gg_protos.h"
#include "gg_gutil.h"
#include "gg_events.h"

#include "ge_protos.h"

#include "ng_objects.h"   // pour deboguer
#include "nn_tree.h"
#include "nn_cmd.h"
#include "gg_icons_xfig.h"
#include "template.h"

static gint popup_width = 900 ,popup_height = 775; // 1200;  //

void set_gg_gui_size (char *s)
{
  int n = sscanf (s ,"%dx%d" ,&popup_width ,&popup_height);
  if (n != 2) {
    fprintf (stderr ,"Error reading GRACEGTK_GUI_SIZE: using default size\n");
    popup_width = 900;
    popup_height = 775;
  }
}

#ifdef DEBUG
static void print_tree_CB (GtkWidget *w ,gpointer p)
{
  print_tree ();
}
static void check_tree_CB (GtkWidget *w ,gpointer p)
{
  check_tree ();
}

void print_objs_CB (GtkWidget *w ,gpointer p)
{
  print_objs ();
}


#endif /* DEBUG */

extern void gg_load_example (char *s);
extern int  gg_load_project_file(char *fn, int as_template);
extern GdkColor  bleuciel ,wheat;

int new_project(char *template); // Provisoire

static char *menu_xml = NULL;


void gg_UsersGuide_CB 	(void) { gg_HelpCB ("doc/UsersGuide.html"); }
void gg_UsersGtk_CB 	(void) { gg_HelpCB ("doc/GraceGTK.pdf"); }
void gg_Tutorial_CB   	(void) { gg_HelpCB ("doc/Tutorial.html"); }
void gg_FAQ_CB        	(void) { gg_HelpCB ("doc/FAQ.html"); }
void gg_CHANGES_CB    	(void) { gg_HelpCB ("doc/CHANGES.html"); }
void gg_LicenceTerms_CB (void) { gg_HelpCB ("doc/GPL.html"); }

void gg_HelpCB (gpointer p);

GdkDisplay *gg_disp = NULL;
GdkScreen *gg_screen = NULL;


GtkWidget *gg_main_window = NULL;

GtkWidget *gg_main_frame = NULL;
GtkUIManager *uiManager = NULL;
GtkActionGroup *actionGroup = NULL;
GtkWidget *gg_main_hbox = NULL;

extern void draw_set_cmap (int gno ,int setno ,int nx ,int ny);

void ESSAI (GtkWidget *w ,gpointer p)
{
//    gg_load_example ("ng_mixed.agr");
   gg_load_project_file ("/home/vincent/tempo/ng_xycmap_1.agr", FALSE);
   gg_drawgraph      ();
  ge_reset_explorer ();

//   gg_load_example ("ng_diode.agr");
//   gg_load_example ("xycolor.agr");
//   gg_load_example ("ng_wavelet.agr");
//   gg_load_example ("ng_spectrum2.agr");
//   gg_load_example ("log2.agr");
//   gg_load_example ("ng_xycmap.agr");
//   gg_load_example ("ng_arcs.agr");
//   nn_xfig_out ();
//    gg_load_example ("ng_if.agr");


//   gg_create_command_popup ();

  //  gg_load_example ("ng_import.agr");
  //  gg_import_popup (NULL ,NULL);
   ge_explorer_popup ();

}

void essai_polar2 (GtkWidget *w ,gpointer p)
{
  gtk_widget_show_all (gg_main_window);
  gg_load_example ("ng_polar2.agr");
}


static GtkWidget *gg_menu_bar ,*gg_helpmenu;
static GtkWidget *gg_undo_menu ,*gg_redo_menu;
static GtkWidget *gg_undo_label = NULL;
static GtkWidget *gg_redo_label;
static GtkWidget *tbar ,*tscroll;
static GtkWidget *gg_toolbar  ,*frleft ,*fright;
GtkWidget *gg_drawing_window ,*gg_canvas;



static GtkWidget *stat_box;
GtkWidget *gg_loclab;		        /* locator label */
static GtkWidget *statlab;		/* status line at the bottom */
static GtkWidget *layer_vbox ,*layer_lab ,*layer_scroll;
static GtkWidget *w_layers[LAYER_MAX];  /* layers check boxes */
static GtkWidget *stack_depth_item;	/* stack depth item on the main panel */
static GtkWidget *curw_item;	/* current world stack item on the main panel */
static GtkWidget *bt_graph_fixed;
static GtkWidget *bt_graph_xy;

static GtkWidget *bt_objs ,*rc_objs;
static GtkWidget *bt_sets ,*rc_sets;
static void bt_CB  (GtkWidget *w ,GtkWidget *pw);

static void gg_layer_toggled_CB (GtkWidget *w ,gpointer p);



/** Toolbar callbacks */
static gboolean gg_bailout_main (GtkWidget *w ,GdkEvent *event ,gpointer p);
static void gg_bailout_CB      (GtkWidget *w ,gpointer p);
static void gg_autoon_CB       (GtkWidget *w ,gpointer p);
static void gg_autoticks_CB    (GtkWidget *w ,gpointer p);
static void gg_autoscale_CB    (GtkWidget *w ,gpointer p);
static void gg_graph_scroll_CB (GtkWidget *w ,gpointer p);
static void gg_graph_zoom_CB   (GtkWidget *w ,gpointer p);
static void gg_world_stack_CB  (GtkWidget *w ,gpointer p);

static void gg_set_graph_fixed_CB (GtkWidget *w ,gpointer p);
static void gg_push_and_zoom (void);

GdkWindow *gg_win = NULL;  /* replace xwin */

#define WSTACK_PUSH         0
#define WSTACK_POP          1
#define WSTACK_CYCLE        2
#define WSTACK_PUSH_ZOOM    3

static gboolean barebones = FALSE;




/** Initialize GTK
 *  Replace initialize_gui
 */
int gg_initialize_gui (int *argc, char **argv)
{
  FILE *fpxml = NULL;

  /* Initialisation */
  gtk_init (argc, &argv);
  gg_disp = gdk_display_get_default ();
  gg_screen = gdk_screen_get_default ();
  menu_xml = malloc ( (strlen (get_grace_home ()) + 20)  * sizeof(char));
  sprintf (menu_xml ,"%s/src/gg.xml" ,get_grace_home ());
  fpxml = fopen (menu_xml ,"r");
  if (fpxml == NULL) {
    printf ("gg.c: file %s not found: check GRACEGTK_HOME environment variable\n" ,menu_xml);
    exit (0);
  } else {
    fclose (fpxml);
  }

  return RETURN_SUCCESS;
}

/*
 * service routines for the View pulldown
 */
void gg_set_statusbar (GtkToggleAction *action ,gpointer p)
{
  if (gtk_toggle_action_get_active (action)) {
    gtk_widget_show (statlab);
  } else {
    gtk_widget_hide (statlab);
  }
}

void gg_set_toolbar (GtkToggleAction *action ,gpointer p)
{
  if (gtk_toggle_action_get_active (action)) {
    gtk_widget_show (tbar);
  } else {
    gtk_widget_hide (tbar);
  }
}

void gg_set_locbar (GtkToggleAction *action ,gpointer p)
{
  if (gtk_toggle_action_get_active (action)) {
    gtk_widget_show (gg_loclab);
  } else {
    gtk_widget_hide (gg_loclab);
  }
}

void gg_drawgraph_CB (GtkWidget *w ,gpointer p)
{
  gg_drawgraph ();
}

static void gg_set_locator_fixed_point (GtkWidget *w ,gpointer p)
{
  gg_set_action_CB (w ,GINT_TO_POINTER (SEL_POINT));
}

static void  gg_clear_locator_fixed_point (GtkWidget *w ,gpointer p)
{
  GLocator locator;

  get_graph_locator (get_cg (), &locator);
  locator.pointset = FALSE;
  set_graph_locator (get_cg(), &locator);
  gg_drawgraph ();
}




/*   nom               icone         label_affiche '  mnemo tooltip       callback */
GtkActionEntry menu_entries[] = {
  /* File menu */
  {"FileAction"      ,NULL           ,"_File"           ,NULL,NULL,NULL}
  ,{"NewAction"      ,GTK_STOCK_NEW  ,"New"            ,NULL,NULL  ,G_CALLBACK (gg_new_CB)}
  ,{"OpenPAction"    ,GTK_STOCK_OPEN ,"Open project"   ,NULL,NULL  ,G_CALLBACK (gg_open_project_popup)}
  ,{"SaveAction"     ,GTK_STOCK_SAVE ,"Save"           ,NULL,NULL  ,G_CALLBACK (gg_save_CB)}
  ,{"SaveAsAction"   ,GTK_STOCK_SAVE_AS ,"Save as..."  ,NULL,NULL  ,G_CALLBACK (gg_saveas_CB)}
  ,{"RevertAction"   ,NULL         ,"Revert to saved"  ,NULL,NULL  ,G_CALLBACK (gg_revert_to_saved_CB)}
  ,{"PrintSAction"   ,NULL         ,"Print setup..."   ,NULL,NULL  ,G_CALLBACK (gg_create_printer_setup_CB)}
  ,{"PrintAction"    ,GTK_STOCK_PRINT,"Print"          ,NULL,NULL  ,G_CALLBACK (gg_do_print_CB)}
  ,{"QuitAction"     ,GTK_STOCK_QUIT ,"Quit"   ,"<Ctl>Q",NULL  ,G_CALLBACK (gg_bailout_CB)}

  /* Edit menu */
  ,{"EditAction"     ,GTK_STOCK_EDIT,"_Edit"            ,NULL,NULL,NULL}
  ,{"UndoAction"     ,NULL  ,"Undo"                    ,NULL,NULL   ,G_CALLBACK (gg_undo_CB)}
  ,{"RedoAction"     ,NULL  ,"Redo"                    ,NULL,NULL   ,G_CALLBACK (gg_redo_CB)}
  ,{"ExploreAction"  ,NULL  ,"Explorer"                ,NULL,NULL   ,G_CALLBACK (ge_explorer_popup)}
  ,{"DataSetAction"  ,NULL  ,"Data sets..."            ,NULL,NULL   ,G_CALLBACK (gg_create_datasetprop_popup)}
  ,{"SetOpAction"    ,NULL  ,"Set operations..."       ,NULL,NULL   ,G_CALLBACK (gg_create_setop_popup_CB)}
  ,{"ArGraphsAction" ,NULL  ,"Arrange graphs..."       ,NULL,NULL   ,G_CALLBACK (ge_project_layout_g5compat_CB)}

  ,{"OvGraphsAction" ,NULL  ,"Overlay graphs..."       ,NULL,NULL   ,G_CALLBACK (gg_create_overlay_popup)}
  ,{"AutoscaleAction",NULL  ,"Autoscale graphs..."     ,NULL,NULL   ,G_CALLBACK (gg_create_autos_popup)}
  ,{"RegionsAction"  ,NULL  ,"Regions"                 ,NULL,NULL,NULL}
  ,{"RStatusAction"  ,NULL  ,"Status..."               ,NULL,NULL   ,G_CALLBACK (gg_define_status_popup)}
  ,{"RDefineAction"  ,NULL  ,"Define..."               ,NULL,NULL   ,G_CALLBACK (gg_create_regiondef_popup)}
  ,{"RClearAction"   ,NULL  ,"Clear..."                ,NULL,NULL   ,G_CALLBACK (gg_create_regionclear_popup)}
  ,{"RReportAction"  ,NULL  ,"Report on..."            ,NULL,NULL   ,G_CALLBACK (gg_create_reporton_popup)}
  ,{"HotAction"      ,NULL  ,"Hot links..."            ,NULL,NULL   ,G_CALLBACK (gg_create_hotlinks_popup)}
  ,{"SetLocAction"   ,NULL  ,"Set locator fixed point" ,NULL,NULL   ,G_CALLBACK (gg_set_locator_fixed_point)}
  ,{"CleLocAction"   ,NULL  ,"Clear locator fixed point",NULL,NULL  ,G_CALLBACK (gg_clear_locator_fixed_point)}
  ,{"LocPropAction"  ,NULL  ,"Locator props..."        ,NULL,NULL   ,G_CALLBACK (gg_create_locator_frame)}
  ,{"PrefsAction"    ,NULL  ,"Preferences..."          ,NULL,NULL   ,G_CALLBACK (gg_create_props_frame)}

  /* Data menu */
  ,{"DataAction"    ,NULL  ,"_Data"                     ,NULL,NULL   ,NULL    }
  ,{"DataOpAction"  ,NULL  ,"Data set operations..."   ,NULL,NULL   ,G_CALLBACK (gg_create_datasetop_popup_CB)}
  ,{"TransfoAction" ,NULL  ,"Transformations"          ,NULL,NULL,NULL}
  ,{"EvExprAction"  ,NULL  ,"Evaluate expression..."   ,NULL,NULL   ,G_CALLBACK (gg_create_eval_popup)}
  ,{"HistoAction"   ,NULL  ,"Histograms..."            ,NULL,NULL   ,G_CALLBACK (gg_create_histo_popup)}
  ,{"FourierAction" ,NULL  ,"Fourier transforms..."    ,NULL,NULL   ,G_CALLBACK (gg_fourier_create_win)}
  ,{"WaveletAction" ,NULL  ,"Wavelet transforms..."    ,NULL,NULL   ,G_CALLBACK (gg_wavelet_create_win)}
  ,{"AverageAction" ,NULL  ,"Running averages..."      ,NULL,NULL   ,G_CALLBACK (gg_create_run_popup)}
  ,{"DiffAction"    ,NULL  ,"Differences/derivation...",NULL,NULL   ,G_CALLBACK (gg_diff_create_win)}
  ,{"SDiffAction"   ,NULL  ,"Seasonal differences..."  ,NULL,NULL   ,G_CALLBACK (gg_create_seasonal_popup)}
  ,{"IntegrAction"  ,NULL  ,"Integration..."           ,NULL,NULL   ,G_CALLBACK (gg_create_int_popup)}
  ,{"InterpAction"  ,NULL  ,"Interpolation/splines..." ,NULL,NULL   ,G_CALLBACK (gg_create_interp_popup)}
  ,{"RegresAction"  ,NULL  ,"Regression..."            ,NULL,NULL   ,G_CALLBACK (gg_create_reg_popup)}
  ,{"NLFitAction"   ,NULL  ,"Non-linear curve fitting..." ,NULL,NULL,G_CALLBACK (gg_create_nonl_popup)}
  ,{"CorelAction"   ,NULL  ,"Correlation/covariance..."   ,NULL,NULL,G_CALLBACK (gg_create_xcor_popup)}
  ,{"FilterAction"  ,NULL  ,"Digital filter..."        ,NULL,NULL   ,G_CALLBACK (gg_create_digf_popup)}
  ,{"ConvolAction"  ,NULL  ,"Linear convolution..."    ,NULL,NULL   ,G_CALLBACK (gg_create_lconv_popup)}
  ,{"GeoTransfoAction",NULL,"Geometric transforms..."  ,NULL,NULL   ,G_CALLBACK (gg_create_geom_popup)}
  ,{"SampleAction"  ,NULL  ,"Sample points..."         ,NULL,NULL   ,G_CALLBACK (gg_create_samp_popup)}
  ,{"PruneAction"   ,NULL  ,"Prune data..."            ,NULL,NULL   ,G_CALLBACK (gg_create_prune_popup)}
  ,{"ExtractAction" ,NULL  ,"Feature extraction..."    ,NULL,NULL   ,G_CALLBACK (gg_create_featext_popup)}

  ,{"ImportAction"       ,NULL  ,"Import"	       ,NULL,NULL ,NULL}
  ,{"AsciiImportAction"  ,NULL  ,"Import ASCII data"   ,NULL,NULL   ,G_CALLBACK (gg_import_popup)}

  ,{"ExportAction"      ,NULL ,"Export" ,NULL,NULL ,NULL}
  ,{"AsciiExportAction" ,NULL ,"Export ASCII data"     ,NULL,NULL   ,G_CALLBACK (gg_create_write_popup)}

  /* Plot menu */
  ,{"PlotAction"     ,NULL  ,"_Plot" ,NULL  ,NULL ,NULL}
  ,{"PlotApAction"   ,NULL  ,"Plot appearance..."  ,NULL,NULL ,G_CALLBACK (ge_project_open_page_tab_CB)}
  ,{"GraphApAction"  ,NULL  ,"Graph appearance..." ,NULL,NULL ,G_CALLBACK (ge_graph_g5compat_CB)}
  ,{"SetApAction"    ,NULL  ,"Set appearance..."   ,NULL,NULL ,G_CALLBACK (ge_set_g5compat_CB)}
  ,{"AxisPropAction" ,NULL  ,"Axis properties..."  ,NULL,NULL ,G_CALLBACK (ge_axis_g5compat_CB)}
  ,{"LoadParAction"  ,NULL  ,"Load parameters..."  ,NULL,NULL ,G_CALLBACK (gg_create_rparams_CB)}
  ,{"SaveParAction"  ,NULL  ,"Save parameters..."  ,NULL,NULL ,G_CALLBACK (gg_create_wparams_CB)}

  /* View menu */
  ,{"ViewAction"     ,NULL  ,"_View"  ,NULL,NULL ,NULL}
  /* for "Show locator bar"  , "Show status bar"  and "Show tool bar"  see  toggle_entries */
  ,{"ZoomPlusAction" ,NULL  ,"Page zoom +"         ,NULL,NULL ,G_CALLBACK (gg_page_zoom_increase_CB)}
  ,{"ZoomMinusAction",NULL  ,"Page zoom -"         ,NULL,NULL ,G_CALLBACK (gg_page_zoom_decrease_CB)}
  ,{"ZoomResetAction",NULL  ,"Page zoom reset"     ,NULL,NULL ,G_CALLBACK (gg_page_zoom_reset_CB)}
  ,{"PageSetAction"  ,NULL  ,"Page setup..."       ,NULL,NULL ,G_CALLBACK (ge_project_open_page_tab_CB)}
  ,{"RedrawAction"   ,NULL  ,"Redraw"              ,NULL,NULL ,G_CALLBACK (gg_drawgraph)}
  ,{"WhiteAction"    ,NULL  ,"White background"    ,NULL,NULL ,G_CALLBACK (gg_bg_white)}
  ,{"BlackAction"    ,NULL  ,"Black background"    ,NULL,NULL ,G_CALLBACK (gg_bg_black)}
  ,{"UpdateAllAction",NULL  ,"Update all"          ,NULL,NULL ,G_CALLBACK (gg_update_all)}

  /* Window menu */
  ,{"WindowAction"   ,NULL  ,"_Window"  ,NULL,NULL,NULL}
  ,{"CmdAction"      ,NULL  ,"Commands"            ,NULL,NULL, G_CALLBACK (gg_create_command_popup)}
  ,{"PtExplorAction" ,NULL  ,"Point explorer"      ,NULL,NULL ,NULL}   /* disabled in GraceGTK */
  ,{"DrawObjAction"  ,NULL  ,"Drawing objects"     ,NULL,NULL ,NULL}   /* disabled in GraceGTK */
  ,{"FontToolAction" ,NULL  ,"Font tool"           ,NULL,NULL ,G_CALLBACK (gg_fontwin_create)}
  ,{"ConsoleAction"  ,NULL  ,"Console"             ,NULL,NULL ,G_CALLBACK (gg_create_monitor_frame_CB)}


  /* Examples menu */
  ,{"ExamplesAction" ,NULL   ,"Examples" ,NULL,NULL,NULL}

  ,{"ExGtkAction"        ,NULL  ,"GraceGTK" ,NULL ,NULL ,NULL}
  ,{"ExGtkExplainAction" ,NULL  ,"Explain"          ,NULL ,NULL ,G_CALLBACK (ng_ex_explain_CB)  }
  ,{"ExGtkArcsAction"    ,NULL  ,"Arcs"             ,NULL ,NULL ,G_CALLBACK (ng_ex_arcs_CB)     }
  ,{"ExGtkImportAction"  ,NULL  ,"Import ASCII"     ,NULL ,NULL ,G_CALLBACK (ng_ex_import_CB)   }
  ,{"ExGtkSplineAction"  ,NULL  ,"Spline"           ,NULL ,NULL ,G_CALLBACK (ng_ex_spline_CB)   }
  ,{"ExGtkXYSplineAction",NULL  ,"XY-spline"        ,NULL ,NULL ,G_CALLBACK (ng_ex_xyspline_CB) }
  ,{"ExGtkFollowMeAction",NULL  ,"Follow Me"        ,NULL ,NULL ,G_CALLBACK (ng_ex_follow_me_CB)}
  ,{"ExGtkDiodeAction"   ,NULL  ,"Diode"            ,NULL ,NULL ,G_CALLBACK (ng_ex_diode_CB)  }
  ,{"ExGtkFourierAction" ,NULL  ,"Fourier"          ,NULL ,NULL ,G_CALLBACK (ng_ex_fourier_CB)  }
  ,{"ExGtkFourier2Action",NULL  ,"Fourier 2"        ,NULL ,NULL ,G_CALLBACK (ng_ex_fourier2_CB) }
  ,{"ExGtkSpectr2Action" ,NULL  ,"Spectrum 2"       ,NULL ,NULL ,G_CALLBACK (ng_ex_spectrum2_CB) }
  ,{"ExGtkXYCmapAction"  ,NULL  ,"XY color map"     ,NULL ,NULL ,G_CALLBACK (ng_ex_xycmap_CB) }
  ,{"ExGtkXYVmapAction"  ,NULL  ,"XY vector map"    ,NULL ,NULL ,G_CALLBACK (ng_ex_xyvmap_CB) }
  ,{"ExGtkNonNLBAction"  ,NULL  ,"NL fit (batch)"   ,NULL ,NULL ,G_CALLBACK (ng_ex_nonnlb_CB) }
  ,{"ExGtkNonNLIAction"  ,NULL  ,"NL fit (interactive)",NULL ,NULL ,G_CALLBACK (ng_ex_nonnli_CB) }
  ,{"ExGtkPolar2Action"  ,NULL  ,"Polar 2"          ,NULL ,NULL ,G_CALLBACK (ng_ex_polar2_CB) }
  ,{"ExReciprocal2Action",NULL  ,"Reciprocal scale 2" ,NULL,NULL  ,G_CALLBACK (ng_ex_reciprocal2_CB)}
  ,{"ExWaveletbAction"   ,NULL  ,"Wavelets (batch)" ,NULL,NULL  ,G_CALLBACK (ng_ex_waveletb_CB)}
  ,{"ExWaveletAction"    ,NULL  ,"Wavelets (interactive)" ,NULL,NULL  ,G_CALLBACK (ng_ex_wavelet_CB)}
  ,{"ExGtkMixedAction"   ,NULL  ,"Mixed"            ,NULL ,NULL ,G_CALLBACK (ng_ex_mixed_CB) }

  ,{"ExamplesG5Action"  ,NULL  ,"grace-5"           ,NULL,NULL,NULL}

  ,{"ExIntroAction"      ,NULL  ,"General intro" ,NULL ,NULL ,NULL}
  ,{"ExExplainAction"    ,NULL  ,"Explain"          ,NULL ,NULL ,G_CALLBACK (gg_ex_explain_CB)   }
  ,{"ExPropertiesAction" ,NULL  ,"Properties"       ,NULL ,NULL ,G_CALLBACK (gg_ex_properties_CB)}
  ,{"ExAxesAction"       ,NULL  ,"Axes"             ,NULL ,NULL ,G_CALLBACK (gg_ex_axes_CB)      }
  ,{"ExFontsAction"      ,NULL  ,"Fonts"            ,NULL,NULL  ,G_CALLBACK (gg_ex_fonts_CB)     }
  ,{"ExArrowsAction"     ,NULL  ,"Arrows"           ,NULL,NULL  ,G_CALLBACK (gg_ex_arrows_CB)    }
  ,{"ExSymbolsAction"    ,NULL  ,"Symbols and lines",NULL,NULL  ,G_CALLBACK (gg_ex_symslines_CB) }
  ,{"ExFillsAction"      ,NULL  ,"Fills"            ,NULL,NULL  ,G_CALLBACK (gg_ex_fills_CB)     }
  ,{"ExWorldAction"      ,NULL  ,"World stack"      ,NULL,NULL  ,G_CALLBACK (gg_ex_world_CB)     }
  ,{"ExInsetAction"      ,NULL  ,"Inset graphs"     ,NULL,NULL  ,G_CALLBACK (gg_ex_tinset_CB)    }
  ,{"ExManyAction"       ,NULL  ,"Many graphs"      ,NULL,NULL  ,G_CALLBACK (gg_ex_manygraphs_CB)}

  ,{"ExXyGAction"        ,NULL  ,"XY graphs" ,NULL,NULL ,NULL}
  ,{"ExLogAction"        ,NULL  ,"Log scale"        ,NULL,NULL  ,G_CALLBACK (gg_ex_tlog_CB)}
  ,{"ExLog2Action"       ,NULL  ,"Log2 scale"       ,NULL,NULL  ,G_CALLBACK (gg_ex_log2_CB)}
  ,{"ExLog2LAction"      ,NULL  ,"Log2/log scale"   ,NULL,NULL  ,G_CALLBACK (gg_ex_log2log_CB)}
  ,{"ExLogitAction"      ,NULL  ,"Logit scale"      ,NULL,NULL  ,G_CALLBACK (gg_ex_logit_CB)}
  ,{"ExReciprocalAction" ,NULL  ,"Reciprocal scale" ,NULL,NULL  ,G_CALLBACK (gg_ex_reciprocal_CB)}
  ,{"ExErrorBAction"     ,NULL  ,"Error bars"       ,NULL,NULL  ,G_CALLBACK (gg_ex_terr_CB)}
  ,{"ExDateAction"       ,NULL  ,"Date/time axis formats",NULL,NULL  ,G_CALLBACK(gg_ex_times_CB)}
  ,{"ExAustraliaAction"  ,NULL  ,"Australia map"    ,NULL,NULL  ,G_CALLBACK (gg_ex_au_CB)}
  ,{"ExCO2Action"        ,NULL  ,"A CO2 analysis"   ,NULL,NULL  ,G_CALLBACK (gg_ex_co2_CB)}
  ,{"ExMotifAction"      ,NULL  ,"Motif statistics" ,NULL,NULL  ,G_CALLBACK (gg_ex_motif_CB)}
  ,{"ExSpectrumAction"   ,NULL  ,"Spectrum"         ,NULL,NULL  ,G_CALLBACK (gg_ex_spectrum_CB)}

  ,{"ExXYCAction"        ,NULL  ,"XY charts"  ,NULL,NULL ,NULL}
  ,{"ExBarAction"        ,NULL  ,"Bar chart"        ,NULL,NULL  ,G_CALLBACK(gg_ex_bar_CB)}
  ,{"ExStackedAction"    ,NULL  ,"Stacked bar"      ,NULL,NULL  ,G_CALLBACK(gg_ex_stackedb_CB)}
  ,{"ExBarWEAction"      ,NULL  ,"Bar chart with error bars"  ,NULL,NULL,G_CALLBACK(gg_ex_chartebar_CB)}
  ,{"ExDifCAction"       ,NULL  ,"Different charts"  ,NULL,NULL ,G_CALLBACK(gg_ex_charts_CB)}

  ,{"ExPolarAction"      ,NULL  ,"Polar graphs" ,NULL,NULL ,NULL}
  ,{"ExPolarGAction"     ,NULL  ,"Polar graph"       ,NULL,NULL  ,G_CALLBACK(gg_ex_polar_CB)}

  ,{"ExPieAction"        ,NULL  ,"Pie charts"   ,NULL,NULL ,NULL}
  ,{"ExPieCAction"       ,NULL  ,"Pie chart"         ,NULL,NULL  ,G_CALLBACK(gg_ex_pie_CB)}

  ,{"ExSpecialSetAction"  ,NULL  ,"Special set presentations"  ,NULL,NULL ,NULL}
  ,{"ExHILOAction"        ,NULL  ,"HILO"             ,NULL,NULL ,G_CALLBACK(gg_ex_hilo_CB)}
  ,{"ExXYRadiusAction"    ,NULL  ,"XY Radius"        ,NULL,NULL ,G_CALLBACK(gg_ex_txyr_CB)}
  ,{"ExXYZAction"         ,NULL  ,"XYZ"              ,NULL,NULL ,G_CALLBACK(gg_ex_xyz_CB)}
  ,{"ExBoxAction"         ,NULL  ,"Box plot"         ,NULL,NULL ,G_CALLBACK(gg_ex_boxplot_CB)}
  ,{"ExVectorAction"      ,NULL  ,"Vector map"       ,NULL,NULL ,G_CALLBACK(gg_ex_vmap_CB)}
  ,{"ExXYSizeAction"      ,NULL  ,"XY Size"          ,NULL,NULL ,G_CALLBACK(gg_ex_xysize_CB)}
  ,{"ExXYColorAction"     ,NULL  ,"XY Color"         ,NULL,NULL ,G_CALLBACK(gg_ex_xycolor_CB)}

  ,{"ExTypeSetAction"     ,NULL  ,"Type setting"  ,NULL,NULL ,NULL}
  ,{"ExSimpleAction"      ,NULL  ,"Simple"           ,NULL,NULL  ,G_CALLBACK(gg_ex_test2_CB)}
  ,{"ExTextTransformAction" ,NULL,"Text transforms"  ,NULL,NULL  ,G_CALLBACK(gg_ex_txttrans_CB)}
  ,{"ExAdvancedAction"    ,NULL  ,"Advanced"         ,NULL,NULL  ,G_CALLBACK(gg_ex_typeset_CB)}


  ,{"ExCalculusAction"    ,NULL  ,"Calculus"  ,NULL,NULL ,NULL}
  ,{"ExNLFitAction"       ,NULL  ,"Non-linear fit"   ,NULL,NULL  ,G_CALLBACK (gg_ex_logistic_CB)}

  ,{"CommentsAction"      ,NULL  ,"Comments"         ,NULL,NULL,NULL}
  ,{"LicenseAction"       ,NULL  ,"License terms"    ,NULL,NULL  ,G_CALLBACK (gg_LicenceTerms_CB)}
  ,{"AboutAction"   ,GTK_STOCK_ABOUT,"About"         ,NULL,NULL  ,G_CALLBACK (gg_print_version_CB)}

  /* Help menu */
  ,{"HelpAction"    ,GTK_STOCK_HELP ,"_Help" ,NULL,NULL,NULL}
  ,{"UserGtkAction"    ,NULL  ,"GraceGTK guide"        ,NULL,NULL ,G_CALLBACK (gg_UsersGtk_CB)}
  ,{"UserGuideAction"  ,NULL  ,"Grace-5 user's Guide"  ,NULL,NULL ,G_CALLBACK (gg_UsersGuide_CB)}
  ,{"TutorAction"      ,NULL  ,"Grace-5 Tutorial"      ,NULL,NULL ,G_CALLBACK (gg_Tutorial_CB)}
  ,{"FAQAction"        ,NULL  ,"Grace-5 FAQ"           ,NULL,NULL ,G_CALLBACK (gg_FAQ_CB)}
  ,{"ChangesAction"    ,NULL  ,"Grace-5 Changes"       ,NULL,NULL ,G_CALLBACK (gg_CHANGES_CB)}

  /* Toolbar */
  ,{"AScaleAction"     ,NULL  ,"As"                  ,NULL ,NULL ,NULL}
  ,{"ZInAction"        ,GTK_STOCK_ZOOM_IN  ," "  ,NULL ,NULL ,NULL   }
  ,{"GoBackAction"     ,GTK_STOCK_GO_BACK  ," "  ,NULL ,NULL ,NULL   }
  ,{"GoForwardAction"  ,GTK_STOCK_GO_FORWARD  ," "  ,NULL ,NULL ,NULL   }
  ,{"GoDownAction"     ,GTK_STOCK_GO_DOWN  ," "  ,NULL ,NULL ,NULL   }
  ,{"GoUpAction"       ,GTK_STOCK_GO_UP  ," "  ,NULL ,NULL ,NULL   }

};

GtkToggleActionEntry  toggle_entries [] = {
  {"ShowLocAction"   	,NULL ,"Show locator bar"      ,NULL,NULL ,G_CALLBACK (gg_set_locbar)    ,TRUE }
  ,{"ShowStaAction"  	,NULL ,"Show status bar"       ,NULL,NULL ,G_CALLBACK (gg_set_statusbar) ,TRUE }
  ,{"ShowToolAction" 	,NULL ,"Show tool bar"         ,NULL,NULL ,G_CALLBACK (gg_set_toolbar)   ,TRUE }
};

/**
 *  Create the GTK GUI
 */
void gg_start_gtk_gui (int *argc, char **argv)
{
  GtkWidget *toolbar_hbox ,*hs ,*but;
  GtkAction *menu_action_1;
  GtkWidget *rc;
  int i;
  char buf[6];


  /* Initialisation du driver GTK */
  /*  Replace xlibinit */
  gg_init();

/* GdkColor : couleurs RGB  de   0 a 257*255 = 65535
 * Voir /usr/share/doc/libgtk2.0-doc/gdk/gdk-Colormaps-and-Colors.html#gdk-color-change
 * pour les noms et les valeurs [0,255] voir /usr/share/X11/rgb.txt     */
  bleuciel.red   = 257*135;     wheat.red   = 257*245;
  bleuciel.green = 257*206;     wheat.green = 257*222;
  bleuciel.blue  = 257*250;     wheat.blue  = 257*179;
  sprintf (sel_cols_str ,"%s" ,get_default_sel_string (SET_XY));

  /* Main window */
  gg_main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title           (GTK_WINDOW (gg_main_window), "GraceGTK");
  gtk_container_set_border_width (GTK_CONTAINER (gg_main_window), 2);
  gtk_window_set_default_size    (GTK_WINDOW (gg_main_window), popup_width, popup_height);
  gtk_widget_show                (gg_main_window);


  /* vbox principale */
  gg_main_frame = gtk_vbox_new (FALSE, 1);
  gtk_container_set_border_width (GTK_CONTAINER (gg_main_frame), 1);
  gtk_container_add (GTK_CONTAINER (gg_main_window), gg_main_frame);

  /* Menubar */
  uiManager = gtk_ui_manager_new ();
  actionGroup = gtk_action_group_new ("menuActionGroup");
  gtk_action_group_add_actions (actionGroup ,menu_entries
				,G_N_ELEMENTS (menu_entries), NULL);

  gtk_action_group_add_toggle_actions (actionGroup ,toggle_entries
				       ,G_N_ELEMENTS (toggle_entries) ,GINT_TO_POINTER (88));

  gtk_ui_manager_insert_action_group (uiManager, actionGroup, 0);
  gtk_ui_manager_add_ui_from_file (uiManager, menu_xml, NULL);
  gg_menu_bar = gtk_ui_manager_get_widget (uiManager, "/MainMenu");
  gtk_box_pack_start (GTK_BOX (gg_main_frame) ,gg_menu_bar , FALSE, TRUE, 0);

  menu_action_1 = gtk_action_group_get_action (actionGroup ,"PtExplorAction");
  gtk_action_set_sensitive (menu_action_1 ,FALSE);
  menu_action_1 = gtk_action_group_get_action (actionGroup ,"DrawObjAction");
  gtk_action_set_sensitive (menu_action_1 ,FALSE);

  /* "Undo / Redo" menus */
  nn_cmd_undo_new ();
  gg_undo_menu = gtk_ui_manager_get_widget (uiManager, "/MainMenu/EditMenu/UndoMenu");
  gg_redo_menu = gtk_ui_manager_get_widget (uiManager, "/MainMenu/EditMenu/RedoMenu");
  gg_undo_label = gtk_bin_get_child (GTK_BIN(gg_undo_menu));
  gg_redo_label = gtk_bin_get_child (GTK_BIN(gg_redo_menu));
  gtk_widget_set_sensitive (gg_undo_label ,FALSE);
  gtk_widget_set_sensitive (gg_redo_label ,FALSE);

  /* Locator label and status line */
  stat_box = gg_CreateHContainer (gg_main_frame);
  gg_loclab = gtk_label_new ("Locator");
  statlab   = gtk_label_new ("Status");
  gtk_box_pack_start (GTK_BOX (stat_box) ,gg_loclab ,FALSE ,FALSE, 0);
  gtk_box_pack_end   (GTK_BOX (stat_box) ,statlab   ,FALSE ,FALSE, 0);

  /* "Help" menu  */
  gg_helpmenu = gtk_ui_manager_get_widget (uiManager, "/MainMenu/HelpMenu");
  gtk_menu_item_set_right_justified ( GTK_MENU_ITEM(gg_helpmenu) ,TRUE);

  /* hbox principale */
  gg_main_hbox = gtk_hbox_new (FALSE, 1);
  gtk_box_set_homogeneous (GTK_BOX(gg_main_hbox) , FALSE);
  gtk_container_add (GTK_CONTAINER (gg_main_frame), gg_main_hbox);

  /* ToolBar */
  gint d = gg_get_depth ();
  tscroll = gtk_scrolled_window_new (NULL ,NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (tscroll)
				  ,GTK_POLICY_NEVER
				  ,GTK_POLICY_AUTOMATIC);
  tbar = gtk_vbox_new (FALSE, 2);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (tscroll) ,tbar);
  gtk_box_pack_start (GTK_BOX (gg_main_hbox) ,tscroll ,FALSE ,FALSE , 0);

  gg_buttonT (tbar ,"Draw" ,gg_drawgraph_CB ,0 ,"Redraw project");
  gg_toolbar = gg_CreateVContainer (tbar);

  toolbar_hbox = gg_Create2VBox (gg_toolbar ,NULL ,NULL ,&frleft ,&fright);
  /* zoom and autoscale */
  gg_buttonB (frleft ,16 ,d ,zoom_bits   ,gg_set_action_CB ,ZOOM_1ST     ,"Zoom current graph in the selected rectangle");
  gg_buttonB (fright ,16 ,d ,auto_bits   ,gg_autoscale_CB  ,AUTOSCALE_XY ,"Autoscale current graph on X and Y axis");
  /* expand/shrink */
  gg_buttonB (frleft ,16 ,d ,expand_bits ,gg_graph_zoom_CB  ,GZOOM_EXPAND ,"Expand viewport, i.e. zoom backward");
  gg_buttonB (fright ,16 ,d ,shrink_bits ,gg_graph_zoom_CB  ,GZOOM_SHRINK ,"Shrink viewport, i.e. zoom forward");
  /* scrolling */
  gg_buttonB (frleft ,16 ,d ,left_bits   ,gg_graph_scroll_CB ,GSCROLL_LEFT ,"Scroll current graph left");
  gg_buttonB (fright ,16 ,d ,right_bits  ,gg_graph_scroll_CB ,GSCROLL_RIGHT,"Scroll current graph right");
  gg_buttonB (frleft ,16 ,d ,down_bits   ,gg_graph_scroll_CB ,GSCROLL_DOWN ,"Scroll current graph down");
  gg_buttonB (fright ,16 ,d ,up_bits     ,gg_graph_scroll_CB ,GSCROLL_UP   ,"Scroll current graph up");
  /* autoticks */
  gg_buttonT (gg_toolbar ,"AutoT" ,gg_autoticks_CB ,0 ,"Automatically set the tick spacing");
  gg_buttonT (gg_toolbar ,"AutoO" ,gg_autoon_CB ,0    ,"Autoscale on the nearest set");
  /* special zoom and autoscale */
  toolbar_hbox = gg_Create2VBox (gg_toolbar ,NULL ,NULL ,&frleft ,&fright);
  gg_buttonT (frleft ,"ZX" ,gg_set_action_CB  ,ZOOMX_1ST        ,"Zoom in X only");
  gg_buttonT (fright ,"ZY" ,gg_set_action_CB  ,ZOOMY_1ST        ,"Zoom in Y only");
  gg_buttonT (frleft ,"AX" ,gg_autoscale_CB   ,AUTOSCALE_X      ,"Autoscale in X only");
  gg_buttonT (fright ,"AY" ,gg_autoscale_CB   ,AUTOSCALE_Y      ,"Autoscale in Y only");
  gg_buttonT (frleft ,"PZ" ,gg_world_stack_CB ,WSTACK_PUSH_ZOOM ,"Push viewport on stack, then Zoom");
  gg_buttonT (fright ,"Pu" ,gg_world_stack_CB ,WSTACK_PUSH      ,"Push viewport on stack");
  gg_buttonT (frleft ,"Po" ,gg_world_stack_CB ,WSTACK_POP       ,"Pop viewport stack");
  gg_buttonT (fright ,"Cy" ,gg_world_stack_CB ,WSTACK_CYCLE     ,"Cycle viewport stack");

  stack_depth_item = gtk_label_new (NULL);
  gtk_box_pack_start (GTK_BOX (gg_toolbar) ,stack_depth_item , FALSE ,FALSE ,1);
  curw_item        = gtk_label_new (NULL);
  gtk_box_pack_start (GTK_BOX (gg_toolbar) ,curw_item ,FALSE ,FALSE ,1);

  /* GRAPH_FIXED versus GRAPH_XY */
  toolbar_hbox = gg_Create2VBox (gg_toolbar ,NULL ,NULL ,&frleft ,&fright);
  bt_graph_fixed = gg_buttonB (frleft ,16 ,d ,isom_bits   ,gg_set_graph_fixed_CB ,GRAPH_FIXED ,"Set GRAPH_FIXED graph type");
  bt_graph_xy    = gg_buttonB (fright ,16 ,d ,noisom_bits ,gg_set_graph_fixed_CB ,GRAPH_XY    ,"Set GRAPH_XY graph type");

  rc = gg_frame (gg_toolbar ,NULL ,&bleuciel ,2 ,1);
  bt_objs = gtk_check_button_new ();
  gg_frame_attach (rc ,bt_objs);
#ifdef WITH_TOOLTIPS
  gtk_widget_set_tooltip_text (bt_objs ,"Click to show/hide other buttons");
#endif
  gg_buttonB (rc ,22 ,d ,edit_bits     ,gg_set_action_CB ,EDIT_OBJ      ,"Pick an object to popup the menu");
  rc_objs = gg_frame (gg_toolbar ,NULL ,&bleuciel ,2 ,3);
  gg_buttonB (rc_objs ,22 ,d ,move_bits     ,gg_set_action_CB ,MOVE_OBJ_1ST  ,"Pick an object and move it");
  gg_buttonB (rc_objs ,22 ,d ,copy_bits     ,gg_set_action_CB ,COPY_OBJ_1ST  ,"Pick an object and copy it");
  gg_buttonB (rc_objs ,22 ,d ,delete_bits   ,gg_set_action_CB ,DEL_OBJ       ,"Pick an object and delete it");
  gg_buttonB (rc_objs ,22 ,d ,scale_bits    ,gg_set_action_CB ,SCALE_OBJ_1ST ,"Pick an handle to scale object");
  gg_buttonB (rc_objs ,22 ,d ,glue_bits     ,gg_set_action_CB ,GLUE_OBJS_1ST ,"Pick a handle to start a compound");
  gg_buttonB (rc_objs ,22 ,d ,break_bits    ,gg_set_action_CB ,BREAK_COMPOUND,"Pick a handle to break a compound");

  rc = gg_frame (gg_toolbar ,NULL ,&wheat ,2 ,1);
  bt_sets = gtk_check_button_new ();
  gg_frame_attach (rc ,bt_sets);
#ifdef WITH_TOOLTIPS
  gtk_widget_set_tooltip_text (bt_sets ,"Click to show/hide other buttons");
#endif
  gg_buttonB (rc ,22 ,d ,deletept_bits ,gg_set_action_CB ,DEL_POINT     ,"Click a point in a set to delete it");
  rc_sets = gg_frame (gg_toolbar ,NULL ,&wheat ,2 ,2);
  gg_buttonB (rc_sets ,22 ,d ,movepx_bits   ,gg_set_action_CB ,MOVX_POINT1ST ,"Click a point in a set to move it along Ox");
  gg_buttonB (rc_sets ,22 ,d ,movepy_bits   ,gg_set_action_CB ,MOVY_POINT1ST ,"Click a point in a set to move it along Oy");
  gg_buttonB (rc_sets ,22 ,d ,movept_bits   ,gg_set_action_CB ,MOVE_POINT1ST ,"Click a point in a set to move it");
  gg_buttonB (rc_sets ,22 ,d ,addpt_bits    ,gg_set_action_CB ,ADD_POINT_1ST ,"Click a point in a set to add a point after it");


  /* One click commands */
  hs = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (gg_toolbar) ,hs ,TRUE ,TRUE ,15);
  gg_buttonT (gg_toolbar ,"Import" ,gg_import_popup ,0         ,"Read a ASCII data file");
  gg_buttonT (gg_toolbar ,"TreeView" ,ge_explorer_popup_CB ,0  ,"Popup the Explorer/TreeView window");

  hs = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (gg_toolbar) ,hs ,TRUE ,TRUE ,15);
  gg_buttonT (gg_toolbar ,"TreeUpdate" ,ge_update_explorer_CB ,0 ,"Refresh the tree view" );

  /* Le dernier exemple */
  gg_buttonT (gg_toolbar ,"Wavelets" ,ng_ex_waveletb_CB     ,0 ,"A selected example");
  /* pour la mise au point */
#ifdef DEBUG
  gg_buttonA (gg_toolbar ,"Print tree"    ,print_tree_CB ,0);
  gg_buttonA (gg_toolbar ,"Check tree"    ,check_tree_CB ,0);
  gg_buttonA (gg_toolbar ,"Print objs"    ,print_objs_CB ,0);
  gg_buttonA (gg_toolbar ,"ESSAI"    ,ESSAI ,0);
#endif
  hs = gtk_hseparator_new ();
  gtk_box_pack_start_defaults (GTK_BOX (gg_toolbar) ,hs);

  but = gtk_button_new_from_stock (GTK_STOCK_QUIT);
  gtk_box_pack_end (GTK_BOX (tbar) ,but , FALSE, TRUE, 1);

  /* Drawing Area   (../src/xmgrace.c 1005 : drawing_window)  */
  gg_drawing_window = gtk_scrolled_window_new (NULL ,NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(gg_drawing_window)
  				  , GTK_POLICY_AUTOMATIC
  				  , GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (gg_main_hbox) ,gg_drawing_window , TRUE, TRUE, 0);

  gg_canvas = gtk_drawing_area_new ();
  /**  Assume PAGE_FIXED   */
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (gg_drawing_window),gg_canvas );
  gtk_widget_modify_bg (GTK_WIDGET(gg_canvas), GTK_STATE_NORMAL ,&wheat);
  gtk_widget_show (gg_canvas);


   /* Layers check boxes */
   layer_scroll = gtk_scrolled_window_new (NULL ,NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (layer_scroll)
				  ,GTK_POLICY_NEVER
				  ,GTK_POLICY_AUTOMATIC
				   );
   layer_vbox = gtk_vbox_new (FALSE, 0);
   gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (layer_scroll) ,layer_vbox);
   gtk_box_pack_start (GTK_BOX (gg_main_hbox) ,layer_scroll ,FALSE ,FALSE , 0);

   layer_lab  = gtk_label_new ("Layers:");
   gtk_box_pack_start (GTK_BOX (layer_vbox) ,layer_lab , FALSE ,FALSE, 0);
   for (i = 0; i < LAYER_MAX; i++) {
     sprintf (buf ,"%d" ,i);
     w_layers[i] = gtk_check_button_new_with_label (buf);
     gtk_box_pack_start (GTK_BOX (layer_vbox) ,w_layers[i] ,FALSE ,FALSE, 0);
   }



  /* a gtk_drawing_area does not handle key-press-event: we must connect to gg_main_window */
  gtk_widget_add_events (GTK_WIDGET (gg_main_window)
			 ,GDK_KEY_PRESS_MASK
			 |GDK_KEY_RELEASE_MASK );
  g_signal_connect (gg_main_window ,"key-press-event"   ,G_CALLBACK (gg_myproc) ,NULL);
  g_signal_connect (gg_main_window ,"key-release-event" ,G_CALLBACK (gg_myproc) ,NULL);
  g_signal_connect (gg_main_window ,"delete-event"      ,G_CALLBACK (gg_bailout_main), GINT_TO_POINTER(1));
  g_signal_connect (but            ,"clicked"           ,G_CALLBACK (gg_bailout_CB) ,NULL);
  g_signal_connect (bt_objs 	   ,"toggled"		,G_CALLBACK (bt_CB) ,rc_objs);
  g_signal_connect (bt_sets 	   ,"toggled"		,G_CALLBACK (bt_CB) ,rc_sets);

  g_signal_connect (gg_canvas ,"expose_event" ,G_CALLBACK (gg_expose_resize_CB), NULL);
  gtk_widget_add_events (GTK_WIDGET(gg_canvas)
			 , GDK_ENTER_NOTIFY_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 );
  g_signal_connect (gg_canvas, "motion-notify-event" ,G_CALLBACK (gg_myproc) ,NULL);
  g_signal_connect (gg_canvas, "button-press-event"  ,G_CALLBACK (gg_myproc) ,NULL);


  /*************  Affichage de la fenetre principale *************/
  gtk_widget_show_all (gg_main_window);

  if (barebones) {
    gtk_widget_hide (statlab);
    gtk_widget_hide (tbar);
    gtk_widget_hide (gg_loclab);
  }
  gg_win = gg_canvas->window;    /* replace xwin */

  gg_init_cursors();
  gg_init_option_menus();
  gg_status_message (NULL);
  update_app_title ();

  inwin = 1;
  //  follow_me_on = TRUE; // ESSAI

  /* Helped by liberforce
     http://www.developpez.net/forums/d983608/general-developpement/programmation-linux/gtk/gtkp/ubuntu-button-label-image-reseau/
  */
  GtkSettings *settings = gtk_settings_get_default ();
  gboolean show_image_ok = FALSE;
  g_object_get (settings, "gtk-button-images", &show_image_ok, NULL);
  if (!show_image_ok) {
    g_object_set (settings, "gtk-button-images", TRUE, NULL);
  }

  gg_set_int (bt_objs ,TRUE);  bt_CB (bt_objs ,rc_objs);
  gg_set_int (bt_sets ,FALSE);  bt_CB (bt_sets ,rc_sets);
  gg_layer_set (LAYER_DEFAULT ,TRUE);
  gg_update_layers_hbox ();
  for (i = 0; i < LAYER_MAX; i++) {
    g_signal_connect (w_layers[i] ,"toggled" ,G_CALLBACK (gg_layer_toggled_CB) ,GINT_TO_POINTER (i));
  }


}  /* gg_start_gtk_gui */


/* sync_canvas_size changed in gg_sync_canvas_size (cf gg_gtkdrv.c) */


/*************************** C A L L B A C K S ***************************/


/** Print the about message
 *  Replace create_about_grtool
 */
void gg_print_version_CB ()
{
  GtkWidget *about ,*fr ,*vbox;
  char buf[1024];

  about = gtk_dialog_new ();
  vbox = GTK_DIALOG(about)->vbox;
  gg_label_new (vbox ,bi_version_string() );
  gg_label_new (vbox ,"This is a beta version, not for production\n");
  gg_label_new (vbox ,"GraceGTK is an evolution of Grace using the GTK+2 API");
  gg_label_new (vbox ,"         first proposed by Patrick VINCENT in 2009");
  gg_label_new (vbox ,"GraceGTK home is htpp://gracegtk.sourceforge.net");
  fr = gg_frame (vbox ,"Legal stuff" ,&wheat ,0 ,1);
  gg_label_new (fr ,"Portions copyright (c) 1991-1995 Paul J Turner");
  gg_label_new (fr ,"Portions copyright (c) 1996-2008 Grace Development Team");
  gg_label_new (fr ,"GraceGTK is distributed under the terms of the GNU General Public License");

  gg_label_new (about ," ");
  fr = gg_frame (vbox ,"Third party copyrights" ,&wheat ,0 ,1);
  gg_label_new (fr ,"Raster driver based on the GD-1.3 library,");
  gg_label_new (fr ,"      Portions copyright (c) 1994-1998 Cold Spring Harbor Laboratory");
  gg_label_new (fr ,"      Portions copyright (c) 1996-1998 Boutell.Com, Inc");
  gg_label_new (fr ,"X-splines and some icons from Xfig (see files)");
#ifdef HAVE_LIBPDF
  gg_label_new (fr, "PDFlib library, Copyright (c) 1997-2004 Thomas Merz and PDFlib GmbH");
#endif


  fr = gg_frame(vbox, "Build info" ,&wheat ,0 ,1);

  sprintf (buf, "Host: %s", bi_system());
  gg_label_new (fr, buf);
  sprintf (buf, "Time: %s", bi_date());
  gg_label_new (fr, buf);

  sprintf (buf ,"GUI toolkit:  GTK+ %d.%d.%d "
	   ,gtk_major_version
	   ,gtk_minor_version
	   ,gtk_micro_version);
  gg_label_new (fr ,buf);

  sprintf (buf ,"Glib %d.%d.%d "
	   ,glib_major_version
	   ,glib_minor_version
	   ,glib_micro_version);
  gg_label_new (fr ,buf);
  sprintf (buf, "T1lib: %s ", bi_t1lib());
  gg_label_new (fr, buf);

  /* FFTW and FFTW3 must be exclusive one from the other */
#ifdef HAVE_FFTW3
  sprintf (buf, "%s" ,bi_fft ());
  gg_label_new (fr, buf);
#endif
#ifdef HAVE_FFTW
  sprintf (buf, "%s" ,bi_fft ());
  gg_label_new (fr, buf);
#endif

  gtk_widget_show_all (about);

}

/**
 *  Replace  autoon_proc  xmgrace.c 530
 */
static void gg_autoon_CB  (GtkWidget *w ,gpointer p)
{
  gg_set_action (0);
  gg_set_action (AUTO_NEAREST);
}



/**
 *  Replace autoticks_proc   xmgrace.c 539
 */
static void gg_autoticks_CB  (GtkWidget *w ,gpointer p)
{
  autotick_axis (get_cg(), ALL_AXES);
  ge_axis_update (get_cg() ,-1);
  gg_drawgraph ();
}

/** Set the message in the left footer
 *  Replace set_left_footer   xmgrace.c 549
 */
void gg_status_message (char *s)
{
  if (s == NULL) {
    char hbuf[64];
    char buf[GR_MAXPATHLEN + 100];
#ifdef HAVE_X11
    gethostname (hbuf, 63);
#else
    sprintf(hbuf ,"gethostname not in Vista");
#endif
    sprintf(buf, "%s, %s, %s", hbuf, gdk_display_get_name (gg_disp), get_docname());
    gtk_label_set_text (GTK_LABEL(statlab) ,buf);
  } else {
    gtk_label_set_text (GTK_LABEL(statlab) ,s);
  }
}

/** Service the autoscale buttons on the main panel
 *  Replace autoscale_proc    xmgrace.c   518
 */
static void gg_autoscale_CB (GtkWidget *w ,gpointer p)
{
  int n = GPOINTER_TO_INT (p);
    int cg = get_cg ();

    if (autoscale_graph (cg ,n) == RETURN_SUCCESS) {
	ge_axis_update (cg ,-1);
        gg_drawgraph ();
    } else {
      errmsg ("Can't autoscale (no active sets?)");
    }
}

/**
 *  Replace  set_stack_message  xmgrace.c 566
 */
void gg_set_stack_message (void)
{
  char buf[16];
  if (stack_depth_item) {
    sprintf(buf, " SD:%1d ", graph_world_stack_size (get_cg()));
    gtk_label_set_text (GTK_LABEL (stack_depth_item), buf);
    sprintf(buf, " CW:%1d ", get_world_stack_current (get_cg()));
    gtk_label_set_text (GTK_LABEL (curw_item), buf);
    }

}

/**
 *  Replace graph_scroll_proc   xmgrace.c 1249
 */
static void gg_graph_scroll_CB (GtkWidget *w ,gpointer p)
{
  int n = GPOINTER_TO_INT (p);
  graph_scroll (n);
  gg_drawgraph ();
}

/**
 *  Replace graph_zoom_proc   xmgrace.c 1255
 */
static void gg_graph_zoom_CB (GtkWidget *w ,gpointer p)
{
  int n = GPOINTER_TO_INT (p);
  graph_zoom (n);
  gg_drawgraph ();
}


/**
 *  Replace world_stack_proc   xmgrace.c 1261
 */

static void gg_world_stack_CB (GtkWidget *w ,gpointer p)
{
  int n = GPOINTER_TO_INT (p);

  switch (n) {
  case WSTACK_PUSH_ZOOM:
    gg_push_and_zoom ();
    break;
  case WSTACK_PUSH:
    push_world ();
    break;
  case WSTACK_POP:
    pop_world ();
    break;
  case WSTACK_CYCLE:
    cycle_world_stack ();
    break;
  default:
    return;
  }
  gg_update_all ();
  ge_update_explorer ();
  gg_drawgraph ();
}

static void gg_set_graph_fixed_CB (GtkWidget *w ,gpointer p)
{
  set_graph_type (get_cg() , GPOINTER_TO_INT (p));
  gg_drawgraph();
  gg_update_bt_graph ();
}

static void gg_bailout_CB (GtkWidget *w ,gpointer p)
{
  if (!is_dirtystate() || yesno ("Exit losing unsaved changes?")) {
    if (resfp)  grace_close (resfp);
    gtk_main_quit ();
  }
}

static gboolean gg_bailout_main (GtkWidget *w ,GdkEvent *event ,gpointer p)
{
  if (!is_dirtystate() || yesno ("Exit losing unsaved changes?")) {

    if (resfp)  grace_close (resfp);
    exit (0);
  } else {
    return TRUE;
  }
}


static void bt_CB  (GtkWidget *w ,GtkWidget *pw)
{
  int bt_on = gg_get_int (w);
  if (bt_on) {
    gtk_widget_show_all (pw);
  } else {
    gtk_widget_hide_all (pw);
  }
}

static void gg_layer_toggled_CB (GtkWidget *w ,gpointer p)
{
  int i = GPOINTER_TO_INT (p);
  layer_set (i ,gg_get_int (w));
  gg_drawgraph ();
}


/******************************************************/

/**
 *  Replace set_barebones   xmgrace.c  715
 */
void set_barebones (int onoff)
{
  barebones = (gboolean) onoff;
}


void set_pagelayout(int layout)
{
  if (layout != PAGE_FIXED)  errmsg("Only  PAGE_FIXED with GTK");
}

/**
 *  Replace   update_all  motifutils.c 4160
 */
void update_all (void)
{
  gg_update_all ();
}

void gg_update_bt_graph (void)
{
  int gno;;

  gno = get_cg ();
  switch (get_graph_type(gno)) {
  case GRAPH_XY:
    gtk_widget_set_sensitive (bt_graph_fixed ,TRUE);
    gtk_widget_set_sensitive (bt_graph_xy    ,FALSE);
    break;
  case GRAPH_FIXED:
    gtk_widget_set_sensitive (bt_graph_fixed ,FALSE);
    gtk_widget_set_sensitive (bt_graph_xy    ,TRUE);
    break;
  default:
    gtk_widget_set_sensitive (bt_graph_fixed ,FALSE);
    gtk_widget_set_sensitive (bt_graph_xy    ,FALSE);
    break;
  }
}


/**
 *  Replace push_and_zoom  events.c  1370
 */
static void gg_push_and_zoom (void)
{
    push_world ();
    gg_set_action (DO_NOTHING);
    gg_set_action (ZOOM_1ST);
}


void gg_layer_set (int layer ,int onoff)
{
  if (gg_main_window != NULL && layer > 0 && layer < LAYER_MAX) {
    gg_set_int (w_layers[layer] ,onoff);
  }
}

void gg_update_layers_hbox (void)
{
  int i ,first_active_layer ,last_active_layer;
  first_active_layer = last_active_layer = -1;
  if (gg_main_window != NULL) {
    gtk_widget_hide_all (layer_scroll);
    //   gtk_widget_hide_all (layer_hbox);
    int nb_layers = 0;
    for (i = 1; i < LAYER_MAX; i++) {
      gg_set_int (w_layers[i] ,layer_is_active (i));
      if (layer_not_used (i) == FALSE) {
	nb_layers++;
	if (nb_layers == 1) first_active_layer = i;
	if (nb_layers == 2) {
	  gtk_widget_show_all (layer_scroll);
	  gtk_widget_hide_all (layer_vbox);
	  gtk_widget_show (layer_vbox);
	  gtk_widget_show (layer_lab);
	  gtk_widget_show_all (w_layers[first_active_layer]);
	}
	gtk_widget_show_all (w_layers[i]);
	last_active_layer = i;
      }
    }
  }
  if (first_active_layer == last_active_layer) {
    gg_layer_set (first_active_layer ,TRUE);
  }
}

/******************************************************/
void gg_undo_update (int undo_count ,int redo_count)
{
  gchar buf[20];
  if (gg_undo_label != NULL) {
    sprintf (buf ,"Undo (%d)" ,undo_count);
    gtk_label_set_text (GTK_LABEL (gg_undo_label) ,buf);
    gtk_widget_set_sensitive (gg_undo_label ,undo_count > 0);

    sprintf (buf ,"Redo (%d)" ,redo_count);
    gtk_label_set_text (GTK_LABEL (gg_redo_label) ,buf);
    gtk_widget_set_sensitive (gg_redo_label ,redo_count > 0);
  }
}

/**
 * gg_undo_CB : callback called when the "Undo" button is clicked
 */
void gg_undo_CB (GtkWidget *w_undo ,gpointer p)
{
  if (nn_cmd_undo_undo () == RETURN_SUCCESS) {
    ge_update_explorer ();
    ge_expand_current  ();
    ge_select_current  ();
    gg_drawgraph ();
  }
}

/**
 * gg_redo_CB : callback called when the "Redo" button is clicked
 */
void gg_redo_CB (GtkWidget *w_redo ,gpointer p)
{
  gg_switch_current_graph (get_cg ());
  if (nn_cmd_undo_redo () == RETURN_SUCCESS) {
    ge_update_explorer ();
    ge_expand_current  ();
    ge_select_current  ();
    gg_drawgraph ();
  }
}

/**************** Utilities *********************/

GdkDrawable *gg_get_win (void)
{
  return GDK_DRAWABLE (gg_main_window->window);
}


