/**
 *  File ge_legendbox.c
 *
 *  Manage menus for Q_LegendBox
 *
 *   Copyright (c) 2010 P. Vincent.    See GNU GPL ../LICENCE
 *  Replace part of Grace graphappwin.c
 *   Home page: http://plasma-gate.weizmann.ac.il/Grace/
 *   Copyright (c) 1991-1995 Paul J Turner, Portland, OR
 *   Copyright (c) 1996-2003 Grace Development Team
 */

#define _GE_LEGENDBOX_

#include <gtk/gtk.h>

#include "globals.h"

#include "defines.h"
#include "utils.h"

#include "gw_pannel.h"
#include "gw_choice.h"
#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_protos.h"
#include "gg_events.h"

#include "ge_protos.h"
#include "ng_objects.h"
#include "wu.h"
#include "nn_cmd.h"
#include "gg_icons_xfig.h"

extern GdkColor  bleuciel ,wheat;

static GtkWidget *titre_item = NULL;
static GtkWidget *vb;

/************************************************************/
static int menu_finalized 	= FALSE;
static int block_instant_update = FALSE;

/************************************************************/
/*  Widgets for legend struct elements (see defines.h 662)  */
/************************************************************/
static GtkWidget *w_active;
static GtkWidget *w_loctype;
static GtkWidget *w_vgap;
static GtkWidget *w_hgap;
static GtkWidget *w_len;
static GtkWidget *w_invert;
static GtkWidget *w_legx;
static GtkWidget *w_legy;
static GtkWidget *w_font;
static GtkWidget *w_charsize;
static GtkWidget *w_color;
static GtkWidget *w_boxpen_color;
static GtkWidget *w_boxpen_pattern;
static GtkWidget *w_boxfillpen_color;
static GtkWidget *w_boxfillpen_pattern;
static GtkWidget *w_boxlinew;
static GtkWidget *w_boxlines;
/************************************************************/
/*  Widgets for QDobject struct  elements (see defines.h 483) */
static Wu layer;
/**************************************************************/



static void ge_legendbox_vw_CB (GtkWidget *w ,gpointer p);

static int rpane_gno = -2;
 
GtkWidget *ge_legendbox_create_menu (GtkWidget *parent)
{
  GtkWidget *vbox ,*vbox1 ,*hbox ,*fr ,*rc1 ,*rc2 ,*rc3 ,*ta ,*bt;
  char buf[32];

  vbox = gg_CreateVContainer (parent);
  sprintf (buf ,"Graph  LegendBox");
  titre_item = gg_label_new (vbox ,buf);

  vb = gg_CreateVContainer (vbox);  
  gtk_box_set_spacing (GTK_BOX (vb) ,0);

  fr = gg_frame (vb  ,"Location" ,&wheat ,0 ,1);
  gg_frame_connect (ge_legendbox_vw_CB);
  w_loctype = gg_combo_new (fr ,"Locate in:",
				    3,
				    "Viewport coords" ,/* COORD_VIEW=0 */
				    "World coords" ,   /* COORD_WORLD=1 */
				    NULL);
  gg_frame_connect (ge_legendbox_apply_CB);
  rc2 = gg_CreateHContainer (fr);
  w_legx = gg_entry_new (rc2 ,"X:" ,10);
  w_legy = gg_entry_new (rc2 ,"Y:" ,10);

  ta 		   = gg_frame 	    (vb  ,"Frame line" ,&bleuciel ,2 ,2);
  w_boxpen_color   = gg_color_new   (ta ,"Color:");
  w_boxpen_pattern = gg_pattern_new (ta ,"Pattern:");
  w_boxlinew   	   = gg_spin_new    (ta ,"Width:" ,0.0 ,MAX_LINEWIDTH ,0.5);
  w_boxlines   	   = gg_lines_new   (ta ,"Style:");

  fr 		       = gg_frame      	(vb  ,"Frame fill" ,&wheat ,1 ,0);
  w_boxfillpen_color   = gg_color_new  	(fr ,"Color:");
  w_boxfillpen_pattern = gg_pattern_new (fr ,"Pattern:");

  rc1 	     = gg_frame        (vb  ,"Text properties" ,&wheat ,0 ,1);
  w_font     = gg_font_new     (rc1 ,"Font:");
  w_color    = gg_color_new    (rc1 ,"Color:");
  w_charsize = gg_charsize_new (rc1 ,"Char size");

  rc1 	 = gg_frame (vb  ,"Placement" ,&bleuciel ,0 ,1);
  rc2 	 = gg_CreateVContainer (rc1);
  rc3 	 = gg_CreateHContainer (rc2);
  w_vgap = gg_combo_new (rc3 ,"V-gap:" ,7
			 ,"0" ,"1" ,"2" ,"3" ,"4" ,"5",
			 NULL);
  w_hgap = gg_combo_new (rc3 ,"H-gap:",
			 7,
			 "0" ,"1" ,"2" ,"3" ,"4" ,"5",
			 NULL);
  w_len  = gg_combo_new (rc2 ,"Legend line length:",
			 16,
			 "0" ,"1" ,"2" ,"3" ,"4",
			 "5" ,"6" ,"7" ,"8" ,"9",
			 "10","11","12","13","14",
			 NULL);
  w_invert = gg_check_new (rc2 ,"Put in reverse order");

  gint d = gg_get_depth ();
  vbox1 = gtk_vbox_new (FALSE ,3);
  gtk_box_pack_end (GTK_BOX (vbox) ,vbox1  ,FALSE ,TRUE ,1);    
  layer.w  = gg_layer_new   (vbox1 ,"Layer");
  hbox 	   = gg_CreateHContainer (vbox1);
  w_active = gg_check_new   (hbox  ,"Enable");
  bt 	   = gg_buttonB     (hbox  ,22 ,d ,move_bits ,gg_act_on_cur_obj_CB ,MOVE_OBJ_1ST ,"Move legendbox");

    /* --------------- Callbacks --------------- */
  menu_finalized = TRUE;
  gg_frame_connect (NULL);

  return vbox;
}


void ge_legendbox_update (int gno)
{
  legend l;
  char buf[32];
  int num;
  QDobject obj;

  if (gno == -2) gno = rpane_gno;

  if (titre_item != NULL && gno >= 0) {
    sprintf (buf ,"Graph %d LegendBox" ,gno);
    gtk_label_set_text (GTK_LABEL (titre_item) ,buf);
    
    num = obj_tid_get_lbox_num (gno);
    block_instant_update = TRUE;
    get_graph_legend (gno  ,&l ,&obj);
    gg_set_int  (layer.w     	      ,obj.layer);
    gg_set_dble (w_charsize 	      ,l.charsize);
    gg_set_int 	(w_active             ,l.active);
    gg_setstr_d (w_legx ,"%.9g"       ,l.legx ,buf);
    gg_setstr_d (w_legy ,"%.9g"       ,l.legy ,buf);
    gg_set_int 	(w_vgap    	      ,l.vgap);
    gg_set_int 	(w_hgap    	      ,l.hgap);
    gg_set_int 	(w_len     	      ,l.len);
    gg_set_int 	(w_invert  	      ,l.invert);
    gg_set_int 	(w_loctype	      ,l.loctype);
    gg_set_int 	(w_font     	      ,l.font);
    gg_set_int 	(w_color    	      ,l.color);
    gg_set_int 	(w_boxfillpen_color   ,l.boxfillpen.color);
    gg_set_int 	(w_boxfillpen_pattern ,l.boxfillpen.pattern);
    gg_set_int 	(w_boxpen_color       ,l.boxpen.color);
    gg_set_int 	(w_boxpen_pattern     ,l.boxpen.pattern);
    gg_set_dble	(w_boxlinew 	      ,l.boxlinew);
    gg_set_int 	(w_boxlines 	      ,l.boxlines);
    gtk_widget_set_sensitive (vb ,l.active);
    rpane_gno = gno;
    block_instant_update = FALSE;
  }
}

void ge_legendbox_apply  (int gno)
{
  legend l ,old;
  QDobject lobj ,oobj;

  if (titre_item != NULL && gno >= 0) {
    get_graph_legend (gno ,&l ,&lobj);
    /* undo/redo and follow_me_on */
    get_graph_legend (gno ,&old ,&oobj);

    lobj.layer           = gg_get_int (layer.w);
    l.charsize 		 = gg_get_dble (w_charsize);
    l.active   		 = gg_get_int (w_active);
    l.vgap     		 = gg_get_int (w_vgap);
    l.hgap     		 = gg_get_int (w_hgap);
    l.len      		 = gg_get_int (w_len);
    l.invert   		 = gg_get_int (w_invert);
    l.loctype  		 = gg_get_int (w_loctype);
    gg_evalexpr(w_legx ,&l.legx);
    gg_evalexpr(w_legy ,&l.legy);
    l.font               = gg_get_int  (w_font);
    l.color              = gg_get_int  (w_color);
    l.boxfillpen.color   = gg_get_int  (w_boxfillpen_color);
    l.boxfillpen.pattern = gg_get_int  (w_boxfillpen_pattern);
    l.boxpen.color       = gg_get_int  (w_boxpen_color);
    l.boxpen.pattern     = gg_get_int  (w_boxpen_pattern);
    l.boxlinew           = gg_get_dble (w_boxlinew);
    l.boxlines           = gg_get_int  (w_boxlines);
    gtk_widget_set_sensitive (vb ,l.active);
    set_graph_legend   (gno  ,&l ,&lobj);
    gg_update_layers_hbox ();
    set_dirtystate ();
    gg_drawgraph ();
    ge_tree_need_update (FALSE);
    nn_cmd_legendbox (gno ,&old ,&oobj ,FALSE ,TRUE);
    ge_hidden_update (Q_LegendBox ,-1 ,Q_Graph ,gno ,!is_graph_legend_active (gno));
    rpane_gno = gno;
  }
}

void ge_legendbox_update_xy (int gno)
{
  char buf[32];
  legend l;
  QDobject obj;
  if (titre_item != NULL) {
    get_graph_legend (gno ,&l ,&obj);
    gg_setstr_d (w_legx ,"%.9g" ,l.legx ,buf);
    gg_setstr_d (w_legy ,"%.9g" ,l.legy ,buf);
  }
}

/**************** C A L L B A C K S ****************/

void ge_legendbox_apply_CB (GtkWidget *w ,gpointer p)
{
  int gno;
  if (instant_update && menu_finalized && 
      block_instant_update == FALSE && obj_tid_is_valid (Q_Graph ,cur_parent_id)) {
    gno = cur_parent_id;
    if (is_valid_gno (gno)) {
      ge_legendbox_apply  (gno);
    }
  }
}

static void ge_legendbox_vw_CB (GtkWidget *w ,gpointer p)
{
  int newloc;
  legend l ,old;
  QDobject obj ,oobj;
  int gno = get_cg ();
  if (titre_item == NULL) return;
  get_graph_legend (gno ,&l   ,&obj);
  get_graph_legend (gno ,&old ,&oobj);
  newloc = gg_get_int (w);
  if (newloc == l.loctype) return;
  if (newloc == COORD_VIEW ) {
    world2view (l.legx ,l.legy ,&(l.legx) ,&(l.legy));
  } else {
    view2world (l.legx ,l.legy ,&(l.legx) ,&(l.legy));
  }
  l.loctype = newloc;
  set_graph_legend (gno ,&l ,&obj);
  ge_legendbox_update_xy (gno);
  nn_cmd_legendbox (gno ,&old ,&oobj ,FALSE ,TRUE);
}


/***************************** Button 3 menu **************************/

LegendBoxMenu3Struct *ge_CreateLegendboxPopupEntries (LegendBoxMenu3Struct *p ,GtkWidget *list
						      ,void (*CB) (GtkWidget *legendbox_list ,gpointer p))
{
  GtkWidget *menu;
  if (p  == NULL) {
    p = xmalloc (sizeof (LegendBoxMenu3Struct));
    menu = gtk_menu_new ();
    p->popup 	 = menu;
    p->hide  	 = gg_CreateMenuButton (menu ,"Hide"          ,'H'  ,list ,CB ,MenuHideCB);
    p->show  	 = gg_CreateMenuButton (menu ,"Show"          ,'S'  ,list ,CB ,MenuShowCB);
  }
  return (p);
}

/**
 *  
 *  Called by ge_tree_CB when Button3 is pressed and
 *  selected objects are legendboxes
 */
void ge_legendbox_popup_menu3 (LegendBoxMenu3Struct *p)
{
  gtk_menu_popup (GTK_MENU(p->popup) ,NULL ,NULL ,NULL ,NULL ,3
		  ,gtk_get_current_event_time () );
}

/**
 * identical to ge_obj_hide ()
 */
static void ge_legendbox_hide (int action ,int num)
{
  legend l;
  QDobject lobj;
  int hide = (action == MenuHideCB);
  int gno  = objs[num].father_id;
  get_graph_legend (gno ,&l ,&lobj);
  l.active = (action != MenuHideCB);
  set_graph_legend   (gno  ,&l ,&lobj);
  objs[num].hidden = hide;
  ge_hidden_update (Q_LegendBox ,-1 ,Q_Graph ,gno ,!is_graph_legend_active (gno));
  if (vb != NULL) {
    gg_set_int 		     (w_active ,l.active);   
    gtk_widget_set_sensitive (vb       ,l.active); 
  }
  gg_update_layers_hbox ();
  set_dirtystate ();
  gg_drawgraph ();
}

void ge_legendbox_menu3_CB  (GtkWidget *w ,gpointer pact)
{
  gint action = GPOINTER_TO_INT (pact);
  switch (action) {
  case MenuHideCB:
  case MenuShowCB:
    if (ge_selection_for_each (action ,ge_legendbox_hide)) {
      gg_drawgraph();
    }
    break;
  }
}
