/* buildinfo.c */

#include <config.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#ifdef HAVE_X11
#include <sys/utsname.h>
#endif

#include <time.h>
#ifndef NONE_GUI
#  include <gtk/gtk.h>
#endif

#include <t1lib.h>
#ifdef HAVE_LIBPNG
#include <png.h>
#endif
#ifdef HAVE_LIBJPEG
#include <jpeglib.h>
#endif
#ifdef HAVE_LIBPDF
#include <pdflib.h>
#endif
#ifdef HAVE_FFTW3
#include <fftw3.h>
#endif
#ifdef HAVE_FFTW
#include <fftw.h>
#endif

#define MAJOR_REV 100
#define MINOR_REV 4
#define PATCHLEVEL 04
#define BETA_VER "" 

#ifndef GRACEGTK_HOME
#  ifdef HAVE_X11
#    define GRACEGTK_HOME "/usr/local/gracegtk"
#  else
#    define GRACEGTK_HOME ".."
#  endif
#endif

#ifndef GRACE_PRINT_CMD
#  define GRACE_PRINT_CMD ""
#endif

#ifndef GRACE_EDITOR
#  define GRACE_EDITOR "emacs "
#endif

#ifndef GRACE_HELPVIEWER
/*
#  define GRACE_HELPVIEWER "konqueror -remote openURL\\\\(%s,new-window\\\\) >>/dev/null 2>&1 || mozilla %s"
#define GRACE_HELPVIEWER "evince %s"
*/
#  define GRACE_HELPVIEWER "firefox %s"
#endif

#ifndef GRACEGTK_HELPVIEWER
#  ifdef HAVE_X11
#  define GRACEGTK_HELPVIEWER "firefox %s"
#  else
#    define GRACEGTK_HELPVIEWER "acroread %s"
#  endif
#endif

static void VersionInfo(FILE *outfile)
{

#ifdef HAVE_X11
    struct utsname u_info;
#endif
    time_t time_info;
    char *ctime_string;

    fprintf(outfile, "#define BI_VERSION_ID %d\n",
            MAJOR_REV*10000 + MINOR_REV*100 + PATCHLEVEL);
    /* 
     * GraceGTK MAJOR_REV numbers are shifted by 100 to allows
     * compatibility with Motif versions, but we don't wont
     * to print this shit
     */
#ifdef BETA_VER
    fprintf(outfile, "#define BI_VERSION \"GraceGTK-%d.%d.%d %s\"\n",
	    MAJOR_REV - 100, MINOR_REV, PATCHLEVEL, BETA_VER);
#else
    fprintf(outfile, "#define BI_VERSION \"GraceGTK-%d.%d.%d\"\n",
	    MAJOR_REV - 100, MINOR_REV, PATCHLEVEL);
#endif

/* We don't want to reproduce the complete config.h,
   but those settings which may be related to problems at runtime */

#ifdef NONE_GUI
    fprintf(outfile, "#define BI_GUI \"none\"\n");
#else
    fprintf(outfile, "#define BI_GUI \" GTK+ %d.%d.%d \"\n",gtk_major_version ,gtk_minor_version ,gtk_micro_version );
#endif
    
    fprintf(outfile, "#define BI_T1LIB \"%s\"\n",
        T1_GetLibIdent());

#ifdef HAVE_LIBPNG
    fprintf(outfile, "#define BI_PNGLIB \"%s\"\n",
        PNG_LIBPNG_VER_STRING);
#else
    fprintf(outfile, "#define BI_PNGLIB \"\"\n");
#endif

#ifdef HAVE_LIBJPEG
    fprintf(outfile, "#define BI_LIBJPEG \"%i\"\n",
        JPEG_LIB_VERSION);
#else
    fprintf(outfile, "#define BI_LIBJPEG \"\"\n");
#endif

#ifdef HAVE_LIBPDF
    fprintf(outfile, "#define BI_LIBPDF \"%s\"\n",
        PDFLIB_VERSIONSTRING);
#else
    fprintf(outfile, "#define BI_LIBPDF \"\"\n");
#endif

#ifdef HAVE_FFTW3
     fprintf (outfile, "#define BI_FFT \"%s\"\n" ,fftw_version);
#else
#  ifdef HAVE_FFTW
     fprintf (outfile, "#define BI_FFT \"%s\"\n" ,fftw_version);
#  endif
#endif

    fprintf(outfile, "#define BI_CCOMPILER \"%s\"\n",
        CCOMPILER);
    
#ifdef HAVE_X11
    uname(&u_info);
    fprintf(outfile, "#define BI_SYSTEM \"%s %s %s %s\"\n",
        u_info.sysname, u_info.version, u_info.release, u_info.machine);
#else
    fprintf(outfile, "#define BI_SYSTEM \"MSWindows\" \n");
#endif

    time_info = time(NULL);
    ctime_string = ctime(&time_info);
    if (ctime_string[strlen(ctime_string) - 1] == '\n') {
        ctime_string[strlen(ctime_string) - 1] = '\0';
    }
    fprintf(outfile, "#define BI_DATE \"%s\"\n", ctime_string);

    fprintf(outfile, "\n");

    fprintf(outfile, "#define GRACEGTK_HOME \"%s\"\n", GRACEGTK_HOME);
    fprintf(outfile, "#define GRACE_EDITOR \"%s\"\n", GRACE_EDITOR);
    fprintf(outfile, "#define GRACE_PRINT_CMD \"%s\"\n", GRACE_PRINT_CMD);
    fprintf(outfile, "#define GRACE_HELPVIEWER \"%s\"\n", GRACE_HELPVIEWER);
    fprintf(outfile, "#define GRACEGTK_HELPVIEWER \"%s\"\n", GRACEGTK_HELPVIEWER);

    return;
}


int main(int argc, char *argv[])
{
    FILE *outfile;

    if (argc == 1) {
	outfile = stdout;
    } else {
        if (!(outfile = fopen(argv[1], "w"))) {
            fprintf(stderr, "Failed to open %s for writing!\a\n", argv[1]);
            exit(1);
        }
    }

    VersionInfo(outfile);
   
    if (outfile != stdout) {
        fclose(outfile);
    }
    exit(0);
}
