/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.util;

import java.util.Locale;
import junit.framework.TestCase;


/** Tests for JaxoLanguage. */
public class JaxoLanguageTest extends TestCase {
    /** Constructor: just calls super.
     * @param testName The name of this test.
     */
    public JaxoLanguageTest(String testName) {
        super(testName);
    }

    /**
     * Test of getLanguageFor method, of class JaxoDraw.JaxoConstants.
     */
    public void testGetLanguageFor() {
        assertEquals("english",
            JaxoLanguage.getLanguageFor(JaxoConstants.ENGLISH));
        assertEquals("german",
            JaxoLanguage.getLanguageFor(JaxoConstants.GERMAN));
        assertEquals("french",
            JaxoLanguage.getLanguageFor(JaxoConstants.FRENCH));
        assertEquals("italian",
            JaxoLanguage.getLanguageFor(JaxoConstants.ITALIAN));
        assertEquals("spanish",
            JaxoLanguage.getLanguageFor(JaxoConstants.SPANISH));
        assertEquals("",
            JaxoLanguage.getLanguageFor(JaxoConstants.NO_MODE));
    }

    /**
     * Test that translate returns an empty string for empty keys.
     */
    public void testTranslate() {
        assertEquals("", JaxoLanguage.translate(""));
    }

    /**
     * Test languageChanged.
     */
    public void testLanguageChanged() {
        JaxoLanguage.languageChanged(JaxoLanguage.GERMAN);
        assertEquals(Locale.GERMAN, JaxoLanguage.locale());
        JaxoLanguage.languageChanged(JaxoLanguage.FRENCH);
        assertEquals(Locale.FRENCH, JaxoLanguage.locale());
        JaxoLanguage.languageChanged(JaxoLanguage.ITALIAN);
        assertEquals(Locale.ITALIAN, JaxoLanguage.locale());
        JaxoLanguage.languageChanged(JaxoLanguage.SPANISH);
        assertEquals("es", JaxoLanguage.locale().getLanguage());
        JaxoLanguage.languageChanged(JaxoLanguage.ENGLISH);
        assertEquals(Locale.ENGLISH, JaxoLanguage.locale());
        JaxoLanguage.languageChanged("stoasteirisch");
        assertEquals(Locale.ENGLISH, JaxoLanguage.locale());
    }
}
