/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.util;

import junit.framework.TestCase;

/**
 * Test JaxoInfo.
 */
public class JaxoInfoTest extends TestCase {

    /** Constructor: just calls super.
     * @param testName The name of this test.
     */
    public JaxoInfoTest(String testName) {
        super(testName);
    }

    /**
     * Test of help method, of class net.sf.jaxodraw.util.JaxoInfo.
     */
    public void testHelp() {
        String result = JaxoInfo.help();
        assertTrue("Help returned empty String!", result.length() > 0);
    }

    /**
     * Test of info method, of class net.sf.jaxodraw.util.JaxoInfo.
     */
    public void testInfo() {
        String result = JaxoInfo.info();
        assertTrue("Info returned empty String!", result.length() > 0);
    }

    /**
     * Test of sysInfo method, of class net.sf.jaxodraw.util.JaxoInfo.
     */
    public void testSysInfo() {
        String result = JaxoInfo.sysInfo();
        assertTrue("sysInfo returned empty String!", result.length() > 0);
    }

    /**
     * Test of about method, of class net.sf.jaxodraw.util.JaxoInfo.
     */
    public void testAbout() {
        String result = JaxoInfo.about(null);
        assertTrue("About returned empty String!", result.length() > 0);
    }

    /**
     * Test of compareVersion method, of class net.sf.jaxodraw.util.JaxoInfo.
     */
    public void testCompareVersion() {
        int result = JaxoInfo.compareVersion(null);
        assertTrue("Wrong compareVersion with null!", result > 0);

        // all future versions should be greater than that
        result = JaxoInfo.compareVersion("1.3.2");
        assertTrue("Wrong compareVersion!", result > 0);
    }

    /**
     * Test of compareVersions method, of class net.sf.jaxodraw.util.JaxoInfo.
     */
    public void testCompareVersions() {
        int result = JaxoInfo.compareVersions("2.0.1", "1.113.2");
        assertTrue("Wrong compareVersions: 2.0.1 > 1.113.2", result > 0);

        result = JaxoInfo.compareVersions("2.0", "2.0-SNAPSHOT");
        assertTrue("Wrong compareVersions: 2.0 > 2.0-SNAPSHOT", result > 0);

        result = JaxoInfo.compareVersions("1.3.2-SNAPSHOT", "1.3.2");
        assertTrue("Wrong compareVersions: 1.3.2-SNAPSHOT < 1.3.2", result < 0);

        result = JaxoInfo.compareVersions("2.0", "2.0.1");
        assertTrue("Wrong compareVersions: 2.0 < 2.0.1", result < 0);

        result = JaxoInfo.compareVersions("2.0.1-abc", "2.0.1-xyz");
        assertTrue("Wrong compareVersions: 2.0.1-abc < 2.0.1-xyz", result < 0);

        result = JaxoInfo.compareVersions("2.0-SNAPSHOT", "2.0-SNAPSHOT");
        assertEquals("Wrong compareVersions: 2.0-SNAPSHOT == 2.0-SNAPSHOT", 0, result);

        result = JaxoInfo.compareVersions("2.0", "2.0.0");
        assertEquals("Wrong compareVersions: 2.0 == 2.0.0", 0, result);

        result = JaxoInfo.compareVersions("2.10", "2.11");
        assertTrue("Wrong compareVersions: 2.10 < 2.11", result < 0);

        result = JaxoInfo.compareVersions("2.0-dev", "2.0.0-dev");
        assertEquals("Wrong compareVersions: 2.0-dev == 2.0.0-dev", 0, result);

        try {
            result = JaxoInfo.compareVersions(null, "2.0.0-dev");
            fail("Comparing null version should throw");
        } catch (NullPointerException e) {
            // expected
            assertNotNull(e);
        }
    }
}
