/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.util;

import junit.framework.TestCase;


/** Tests for JaxoGreek.*/
public class JaxoGreekTest extends TestCase {
    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoGreekTest(String testName) {
        super(testName);
    }

    /**
     * Test of getLatexGreekLetter method, of class JaxoDraw.JaxoGreek.
     */
    public void testGetLatexGreekLetter() {
        assertEquals("\\alpha", JaxoGreek.getLatexCommand(JaxoGreek.ALPHA));
        assertEquals("\\Omega",
            JaxoGreek.getLatexCommand(JaxoGreek.UPPER_OMEGA));
        assertNull(JaxoGreek.getLatexCommand(' '));
    }

    /**
     * Test of getGreekLetter method, of class JaxoDraw.JaxoGreek.
     */
    public void testGetGreekLetter() {
        assertEquals(JaxoGreek.ALPHA, JaxoGreek.getCharacter("\\alpha"));
        assertEquals(JaxoGreek.UPPER_OMEGA, JaxoGreek.getCharacter("\\Omega"));
        assertEquals('\u0000', JaxoGreek.getCharacter(""));
    }

    /**
     * Test of isGreekLetter method, of class JaxoDraw.JaxoGreek.
     */
    public void testIsGreekLetter() {
        assertTrue(JaxoGreek.isGreekCharacter(JaxoGreek.ALPHA));
        assertTrue(JaxoGreek.isGreekCharacter(JaxoGreek.UPPER_OMEGA));
        assertFalse(JaxoGreek.isGreekCharacter('a'));
    }

    /**
     * Test of isLatexGreekLetter method, of class JaxoDraw.JaxoGreek.
     */
    public void testIsLatexGreekLetter() {
        assertTrue(JaxoGreek.isLatexCommand("\\alpha"));
        assertTrue(JaxoGreek.isLatexCommand("\\Omega"));
        assertFalse(JaxoGreek.isLatexCommand("alpha"));
    }

}
