/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.plugin;

import java.io.InputStream;

import javax.swing.JComponent;

import java.util.List;
import java.util.Set;

import junit.framework.TestCase;

import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.io.JaxoPreview;

/**
 * Test for JaxoPluginInfo.
 */
public class JaxoPluginInfoTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoPluginInfoTest(String testName) {
        super(testName);
    }

    /** Test getPluginInfo. */
    public void testGetPluginInfo() {
        JaxoPluginInfo result = JaxoPluginInfo.getPluginInfo();
        assertNotNull(result);
    }

    /** Test availablePlugins. */
    public void testAvailablePlugins() {
        String result = JaxoPluginInfo.getPluginInfo().availablePlugins();
        assertNotNull(result);
    }

    /** Test getAvailablePlugins. */
    public void testGetAvailablePlugins() {
        Set<String> result = JaxoPluginInfo.getPluginInfo().getAvailablePlugins();
        assertNotNull(result);
    }

    /** Test getExportFormats. */
    public void testGetExportFormats() {
        List<Object> result = JaxoPluginInfo.getPluginInfo().getExportFormats();
        assertNotNull(result);
        // export formats have to contain at least the built-ins
        assertTrue("Wrong number of export formats!", result.size() >= 3);
    }

    /** Test getImportFormats. */
    public void testGetImportFormats() {
        List<JaxoImportPlugin> result = JaxoPluginInfo.getPluginInfo().getImportFormats();
        assertNotNull(result);
    }

    /** Test getExportFormats. */
    public void testAddRemovePlugin() {
        int plugins = plugins();
        int exports = exports();
        int imports = imports();

        ExportPluginStub exportPlugin = new ExportPluginStub();
        ImportPluginStub importPlugin = new ImportPluginStub();

        JaxoPluginInfo.getPluginInfo().addPlugin(exportPlugin);
        assertEquals(plugins + 1, plugins());
        assertEquals(exports + 1, exports());
        assertEquals(imports, imports());
        JaxoPluginInfo.getPluginInfo().addPlugin(exportPlugin);
        assertEquals(plugins + 1, plugins());
        assertEquals(exports + 1, exports());
        assertEquals(imports, imports());
        JaxoPluginInfo.getPluginInfo().addPlugin(importPlugin);
        assertEquals(plugins + 2, plugins());
        assertEquals(exports + 1, exports());
        assertEquals(imports + 1, imports());
        JaxoPluginInfo.getPluginInfo().addPlugin(null);
        assertEquals(plugins + 2, plugins());
        assertEquals(exports + 1, exports());
        assertEquals(imports + 1, imports());

        JaxoPluginInfo.getPluginInfo().removePlugin(exportPlugin);
        assertEquals(plugins + 1, plugins());
        assertEquals(exports, exports());
        assertEquals(imports + 1, imports());
        JaxoPluginInfo.getPluginInfo().removePlugin(exportPlugin);
        assertEquals(plugins + 1, plugins());
        assertEquals(exports, exports());
        assertEquals(imports + 1, imports());
        JaxoPluginInfo.getPluginInfo().removePlugin(null);
        assertEquals(plugins + 1, plugins());
        assertEquals(exports, exports());
        assertEquals(imports + 1, imports());
        JaxoPluginInfo.getPluginInfo().removePlugin(importPlugin);
        assertEquals(plugins, plugins());
        assertEquals(exports, exports());
        assertEquals(imports, imports());
    }

    private int plugins() {
        return JaxoPluginInfo.getPluginInfo().getAvailablePlugins().size();
    }

    private int exports() {
        return JaxoPluginInfo.getPluginInfo().getExportFormats().size();
    }

    private int imports() {
        return JaxoPluginInfo.getPluginInfo().getImportFormats().size();
    }

    // private test classes

    private class ExportPluginStub extends JaxoExportPlugin {

        /** {@inheritDoc} */
        public void commitConfiguration() {
            //
        }

        /** {@inheritDoc} */
        public JComponent getConfigurationPanel() {
            return null;
        }

        /** {@inheritDoc} */
        protected void exportTo(String arg0)
                throws JaxoPluginExecutionException {
            //
        }

        /** {@inheritDoc} */
        public void preview(JaxoPreview arg0, boolean arg1) {
            //
        }

        /** {@inheritDoc} */
        public String getWarningForGraph() {
            return null;
        }

        /** {@inheritDoc} */
        public String getFormatName() {
            return null;
        }

        /** {@inheritDoc} */
        public String getFileExtension() {
            return null;
        }

        /** {@inheritDoc} */
        public String getFileExtensionDescription() {
            return null;
        }

        /** {@inheritDoc} */
        public String pluginId() {
            return "internalExportTestPlugin";
        }

        /** {@inheritDoc} */
        public String getShortName() {
            return null;
        }

        /** {@inheritDoc} */
        public String description() {
            return null;
        }

        /** {@inheritDoc} */
        public String version() {
            return null;
        }

        /** {@inheritDoc} */
        public boolean makeAvailableAtRuntime() {
            return true;
        }

        /** {@inheritDoc} */
        public void updateLanguage() {
            //
        }
    }

    private class ImportPluginStub extends JaxoImportPlugin {

        /** {@inheritDoc} */
        protected JaxoGraph importGraph(InputStream inputStream)
                throws JaxoPluginExecutionException {
            return null;
        }

        /** {@inheritDoc} */
        public String getFormatName() {
            return null;
        }

        /** {@inheritDoc} */
        public String getFileExtension() {
            return null;
        }

        /** {@inheritDoc} */
        public String getFileExtensionDescription() {
            return null;
        }

        /** {@inheritDoc} */
        public String pluginId() {
            return "internalImportTestPlugin";
        }

        /** {@inheritDoc} */
        public String getShortName() {
            return null;
        }

        /** {@inheritDoc} */
        public String description() {
            return null;
        }

        /** {@inheritDoc} */
        public String version() {
            return null;
        }

        /** {@inheritDoc} */
        public boolean makeAvailableAtRuntime() {
            return true;
        }

        /** {@inheritDoc} */
        public void updateLanguage() {
            //
        }
    }
}
