/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.loop;

import junit.framework.TestCase;

import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.util.JaxoColor;

/**
 * Test for JaxoLoopOptionsPanel.
 */
public class JaxoLoopOptionsPanelTest extends TestCase {

    /**
     * Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoLoopOptionsPanelTest(String testName) {
        super(testName);
    }

    /** Test preparePanel for JaxoFLoop. */
    public void testPreparePanelForFLoop() {
        initLoopAndCheckPanel(new JaxoFLoop());
    }

    /** Test preparePanel for JaxoGLoop. */
    public void testPreparePanelForGLoop() {
        initLoopAndCheckPanel(new JaxoGLoop());
    }

    /** Test preparePanel for JaxoSLoop. */
    public void testPreparePanelForSLoop() {
        initLoopAndCheckPanel(new JaxoSLoop());
    }

    /** Test preparePanel for JaxoPLoop. */
    public void testPreparePanelForPLoop() {
        initLoopAndCheckPanel(new JaxoPLoop());
    }

    /** Test preparePanel for JaxoGlLoop. */
    public void testPreparePanelForGlLoop() {
        initLoopAndCheckPanel(new JaxoGlLoop());
    }

    private void initLoopAndCheckPanel(JaxoLoopObject loop) {
        loop.setLocation(100, 100);
        loop.setRelWAndH(100, 100);
        loop.setColor(JaxoColor.GREEN);
        loop.setStrokeWidth(1.f);
        loop.setDash(1.f);
        loop.setPaintArrow(false);
        loop.setFlip(false);
        loop.setDoubleLine(false);
        loop.setDLSeparation(2.f);

        if (loop instanceof JaxoWiggleObject) {
            ((JaxoWiggleObject) loop).setWiggles(15);
            ((JaxoWiggleObject) loop).setAmp(15);
        }

        JaxoObjectEditPanel panel = new JaxoOptionsPanel(loop);

        assertNotNull(panel);
        loop.prepareEditPanel(panel);

    }

}
