/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.fill;

import junit.framework.TestCase;

import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.util.JaxoColor;

/**
 * Test for JaxoFillOptionsPanel.
 */
public class JaxoFillOptionsPanelTest extends TestCase {

    /**
     * Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoFillOptionsPanelTest(String testName) {
        super(testName);
    }

    /** Test preparePanel for JaxoBlob. */
    public void testPreparePanelForBlob() {
        initFillObAndCheckPanel(new JaxoBlob());
    }

    /** Test preparePanel for JaxoBox. */
    public void testPreparePanelForBox() {
        initFillObAndCheckPanel(new JaxoBox());
    }

    private void initFillObAndCheckPanel(JaxoFillObject fillOb) {
        fillOb.setLocation(100, 100);
        fillOb.setRelWAndH(100, 100);
        fillOb.setStrokeWidth(1.f);
        fillOb.setColor(JaxoColor.GREEN);
        fillOb.setFillColor(JaxoColor.YELLOW);

        JaxoObjectEditPanel panel = new JaxoOptionsPanel(fillOb);

        assertNotNull(panel);
        fillOb.prepareEditPanel(panel);
    }


}
