/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.fill;

import junit.framework.TestCase;

import net.sf.jaxodraw.util.JaxoColor;


/** Tests methods in JaxoFillObject using JaxoBox as instance. */
public class JaxoFillObjectTest extends TestCase {
    private final JaxoBox fill = new JaxoBox();

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoFillObjectTest(String testName) {
        super(testName);
    }

    /** JUnit setup: initialize the object. */
    @Override
    protected void setUp() {
        init();
    }

    /** Tests latexWidth. */
    public void testLatexWidth() {
        String expected = "\\SetWidth{1.0}";
        String actual = fill.latexWidth();
        assertEquals("Latex SetWidth commands do not match!", expected, actual);

    }

    private void init() {
        fill.setLocation(100, 100);
        fill.setRelWAndH(100, 100);
        fill.setStrokeWidth(1.f);
        fill.setColor(JaxoColor.GREEN);
        fill.setFillColor(JaxoColor.YELLOW);
    }

    /** Tests rescaleObject. */
    public void testRescaleObject() {
        int orx = fill.getX();
        int ory = fill.getY();
        fill.rescaleObject(orx, ory, 2.f);
        assertEquals("Box x didn't get rescaled right!", 200, fill.getRelw());
        assertEquals("Box y didn't get rescaled right!", 200, fill.getRelh());

    }

    /** Tests float compare methods. */
    public void testFloatCompare() {
        fill.setStrokeWidth(3.f);
        assertTrue(fill.strokeIs(3.000000001f));
        assertFalse(fill.strokeIs(3.01f));

    }
}
