/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.bezier;

import junit.framework.TestCase;

import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.util.JaxoColor;

/**
 * Test for JaxoBezierOptionsPanel.
 */
public class JaxoBezierOptionsPanelTest extends TestCase {

    /**
     * Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoBezierOptionsPanelTest(String testName) {
        super(testName);
    }

    /** Test preparePanel for JaxoFBezier. */
    public void testPreparePanelForFBezier() {
        initBezierAndCheckPanel(new JaxoFBezier());
    }

    /** Test preparePanel for JaxoGBezier. */
    public void testPreparePanelForGBezier() {
        initBezierAndCheckPanel(new JaxoGBezier());
    }

    /** Test preparePanel for JaxoSBezier. */
    public void testPreparePanelForSBezier() {
        initBezierAndCheckPanel(new JaxoSBezier());
    }

    /** Test preparePanel for JaxoPBezier. */
    public void testPreparePanelForPBezier() {
        initBezierAndCheckPanel(new JaxoPBezier());
    }

    /** Test preparePanel for JaxoGlBezier. */
    public void testPreparePanelForGlBezier() {
        initBezierAndCheckPanel(new JaxoGlBezier());
    }

    private void initBezierAndCheckPanel(JaxoBezierObject bezier) {
        bezier.setLocation(50, 50, 100, 50, 100, 100, 50, 100);
        bezier.setColor(JaxoColor.GREEN);
        bezier.setStrokeWidth(1.f);
        bezier.setDash(1.f);
        bezier.setPaintArrow(false);
        bezier.setArrowPosition(0.5f);
        bezier.setFlip(false);
        bezier.setDoubleLine(false);
        bezier.setDLSeparation(2.f);

        if (bezier instanceof JaxoWiggleObject) {
            ((JaxoWiggleObject) bezier).setWiggles(15);
            ((JaxoWiggleObject) bezier).setAmp(15);
        }

        JaxoObjectEditPanel panel = new JaxoOptionsPanel(bezier);

        assertNotNull(panel);
        bezier.prepareEditPanel(panel);
    }

}
