/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.object.arrow;

import java.awt.BasicStroke;
import java.awt.Color;


/**
 * Test JaxoDefaultArrow.
 */
public class JaxoDefaultArrowTest extends AbstractBaseArrowTest {

    private JaxoDefaultArrow instance;

    /**
     * Constructor: just calls super().
     *
     * @param testName The name of this test.
     */
    public JaxoDefaultArrowTest(String testName) {
        super(testName);
    }

    /**
     * {@inheritDoc}
     *
     * @throws Exception if any.
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        instance = new JaxoDefaultArrow();
    }

    /**
     * Test of isCopy method, of class JaxoDefaultArrow.
     */
    public void testIsCopy() {
        JaxoDefaultArrow copy = (JaxoDefaultArrow) instance.copy();
        NullArrow nullArrow = new NullArrow();
        EmptyDefaultArrow emptyArrow = new EmptyDefaultArrow();
        assertTrue(instance.isCopy(copy));
        assertFalse(instance.isCopy(nullArrow));
        assertFalse(instance.isCopy(emptyArrow));
        assertTrue(instance.isCopy(new JaxoDefaultArrow()));

        assertFalse(emptyArrow.isCopy(nullArrow));

        copy = (JaxoDefaultArrow) instance.copy();
        copy.setArrowInset(0.123f);
        assertFalse(copy.isCopy(instance));
        copy = (JaxoDefaultArrow) instance.copy();
        copy.setArrowLength(0.123f);
        assertFalse(copy.isCopy(instance));
        copy = (JaxoDefaultArrow) instance.copy();
        copy.setArrowWidth(0.123f);
        assertFalse(copy.isCopy(instance));
        copy = (JaxoDefaultArrow) instance.copy();
        copy.setFilled(false);
        assertFalse(copy.isCopy(instance));
        copy = (JaxoDefaultArrow) instance.copy();
        copy.setColor(Color.CYAN);
        assertFalse(copy.isCopy(instance));
        copy = (JaxoDefaultArrow) instance.copy();
        copy.setFillColor(Color.YELLOW);
        assertFalse(copy.isCopy(instance));
        copy = (JaxoDefaultArrow) instance.copy();
        copy.setStroke(new BasicStroke(25.6f));
        assertFalse(copy.isCopy(instance));

        copy = (JaxoDefaultArrow) instance.copy();
        copy.setColor(null);
        assertFalse(copy.isCopy(instance));
        instance.setColor(null);
        assertTrue(copy.isCopy(instance));

        copy.setFillColor(null);
        assertFalse(copy.isCopy(instance));
        instance.setFillColor(null);
        assertTrue(copy.isCopy(instance));

        copy.setStroke(null);
        assertFalse(copy.isCopy(instance));
        instance.setStroke(null);
        assertTrue(copy.isCopy(instance));
    }

    /**
     * Test of latexCommand method, of class JaxoDefaultArrow.
     */
    public void testLatexCommand() {
        String expect =
                "arrow,arrowpos=0.5,arrowlength=5,arrowwidth=2,arrowinset=0.2";
        assertEquals(expect, instance.latexCommand(0.5f, 1.f));
    }

    /**
     * Test of getBounds method, of class JaxoDefaultArrow.
     */
    public void testGetBounds() {
        JaxoArrow.Coordinates coords = new JaxoArrow.Coordinates(5, 5, Math.PI);
        assertNotNull(instance.getBounds(coords));
    }

    /**
     * Test of getEditPanel method, of class JaxoDefaultArrow.
     */
    public void testGetEditPanel() {
        assertNotNull(instance.getEditPanel());
    }

    /**
     * {@inheritDoc}
     */
    public AbstractBaseArrow getInstance() {
        return instance;
    }
}
