/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object.arc;

import junit.framework.TestCase;

import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.util.JaxoColor;

/**
 * Test for JaxoArcOptionsPanel.
 */
public class JaxoArcOptionsPanelTest extends TestCase {

    /**
     * Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoArcOptionsPanelTest(String testName) {
        super(testName);
    }

    /** Test preparePanel for JaxoFArc. */
    public void testPreparePanelForFArc() {
        initArcAndCheckPanel(new JaxoFArc());
    }

    /** Test preparePanel for JaxoGArc. */
    public void testPreparePanelForGArc() {
        initArcAndCheckPanel(new JaxoGArc());
    }

    /** Test preparePanel for JaxoSArc. */
    public void testPreparePanelForSArc() {
        initArcAndCheckPanel(new JaxoSArc());
    }

    /** Test preparePanel for JaxoPArc. */
    public void testPreparePanelForPArc() {
        initArcAndCheckPanel(new JaxoPArc());
    }

    /** Test preparePanel for JaxoGlArc. */
    public void testPreparePanelForGlArc() {
        initArcAndCheckPanel(new JaxoGlArc());
    }

    private void initArcAndCheckPanel(JaxoArcObject arc) {
        arc.setLocation(50, 50, 100, 50, 100, 100);
        arc.setColor(JaxoColor.GREEN);
        arc.setStrokeWidth(1.f);
        arc.setDash(1.f);
        arc.setPaintArrow(false);
        arc.setFlip(false);
        arc.setDoubleLine(false);
        arc.setDLSeparation(2.f);

        if (arc instanceof JaxoWiggleObject) {
            ((JaxoWiggleObject) arc).setWiggles(15);
            ((JaxoWiggleObject) arc).setAmp(15);
        }

        JaxoObjectEditPanel panel = new JaxoOptionsPanel(arc);

        assertNotNull(panel);
        arc.prepareEditPanel(panel);
    }

}
