/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object;

import java.awt.Color;

import java.util.ArrayList;
import java.util.Collection;

import net.sf.jaxodraw.AbstractJaxoBaseTest;
import net.sf.jaxodraw.object.line.JaxoFLine;
import net.sf.jaxodraw.object.loop.JaxoFLoop;

/**
 *
 */
public class JaxoObjectListTest extends AbstractJaxoBaseTest {

    /**
     * Constructor.
     *
     * @param testName The name of this test.
     */
    public JaxoObjectListTest(String testName) {
        super(testName);
    }

    /**
     * Test of constructors, of class JaxoObjectList.
     */
    public void testConstructor() {
        Collection<JaxoObject> list = new ArrayList<JaxoObject>(2);
        list.add(new JaxoFLine());
        list.add(new JaxoFLoop());
        JaxoList<JaxoObject> instance = new JaxoObjectList<JaxoObject>(list);
        assertEquals(2, instance.size());

        //JaxoList<JaxoFLine> another = new JaxoObjectList<JaxoFLine>(list); // not allowed!

        Collection<JaxoFLine> fline = new ArrayList<JaxoFLine>(1);
        fline.add(new JaxoFLine());
        JaxoList<JaxoFLine> ano2 = new JaxoObjectList<JaxoFLine>(fline);
        JaxoList<JaxoObject> ano3 = new JaxoObjectList<JaxoObject>(fline);
        JaxoFLine ob2 = ano2.get(0);
        JaxoObject ob22 = ano3.get(0);
        assertNotNull(ob2);
        assertNotNull(ob22);

        //JaxoList<String> l2 = new JaxoObjectList<String>(); // not allowed!
        //JaxoList<JaxoObject> l3 = new JaxoObjectList<JaxoFLine>(); // not allowed!
        //JaxoList<JaxoFLine> l5 = new JaxoObjectList<JaxoObject>(); // not allowed!
        JaxoList<JaxoFLine> l4 = new JaxoObjectList<JaxoFLine>();
        l4.add(ob2);
        JaxoFLine ob3 = l4.get(0);
        assertNotNull(ob3);
    }

    /**
     * Test of add method, of class JaxoObjectList.
     */
    public void testAdd() {
        JaxoObjectList<JaxoObject> instance = new JaxoObjectList<JaxoObject>();
        assertTrue(instance.add(new JaxoFLine()));

        assertEquals(1, instance.size());
        instance.add(0, new JaxoFLine());
        assertEquals(2, instance.size());
        instance.add(1, new JaxoFLine());
        assertEquals(3, instance.size());
    }

    /**
     * Test of addAll method, of class JaxoObjectList.
     */
    public void testAddAll() {
        Collection<JaxoObject> list = new ArrayList<JaxoObject>(2);
        list.add(new JaxoFLine());
        list.add(new JaxoFLoop());
        JaxoObjectList<JaxoObject> instance = new JaxoObjectList<JaxoObject>();
        instance.addAll(list);
        assertEquals(2, instance.size());
        list.add(new JaxoFLine());
        instance.addAll(1, list);
        assertEquals(5, instance.size());

        //instance.addAll(new ArrayList<String>(1)); // not allowed!
        instance.addAll(new ArrayList<JaxoFLine>(1));
    }

    /**
     * Test of copyOf method, of class JaxoObjectList.
     */
    public void testCopyOf() {
        JaxoList<JaxoObject> instance = new JaxoObjectList<JaxoObject>();
        instance.add(new JaxoFLine());
        instance.add(new JaxoFLoop());

        JaxoList<JaxoObject> copy = instance.copyOf();

        assertNotSame(instance.get(0), copy.get(0));
        assertTrue(instance.get(0).isCopy(copy.get(0)));
        assertNotSame(instance.get(1), copy.get(1));
        assertTrue(instance.get(1).isCopy(copy.get(1)));
    }

    /**
     * Test of set method, of class JaxoObjectList.
     */
    public void testSet() {
        JaxoObjectList<JaxoObject> instance = new JaxoObjectList<JaxoObject>();
        instance.add(new JaxoFLine());
        instance.set(0, new JaxoFLoop());
        assertTrue(instance.get(0) instanceof JaxoFLoop);
    }

    /**
     * Test of isCopy method, of class JaxoObjectList.
     */
    public void testIsCopy() {
        JaxoObjectList<JaxoObject> instance = new JaxoObjectList<JaxoObject>();
        assertFalse(instance.isCopy(null));
        assertTrue(instance.isCopy(instance));
    }

    /**
     * Test of moveAllObjects method, of class JaxoObjectList.
     */
    public void testMoveAllObjects() {
        JaxoFLine line = new JaxoFLine();
        JaxoFLoop loop = new JaxoFLoop();
        line.setLocation(100, 100, 200, 200);
        loop.setLocation(300, 400, 500, 600);
        JaxoObjectList<JaxoObject> instance = new JaxoObjectList<JaxoObject>();
        instance.add(line);
        instance.add(loop);

        instance.moveAllObjects(0, 0);
        assertEquals(100, line.getX());
        assertEquals(300, loop.getX());
        assertEquals(100, line.getY());
        assertEquals(400, loop.getY());

        instance.moveAllObjects(100, -100);
        assertEquals(200, line.getX());
        assertEquals(400, loop.getX());
        assertEquals(0, line.getY());
        assertEquals(300, loop.getY());
    }

    /**
     * Test of setColor method, of class JaxoObjectList.
     */
    public void testSetColor() {
        Color color = Color.BLUE;
        JaxoObjectList<JaxoObject> instance = new JaxoObjectList<JaxoObject>();
        JaxoFLine line = new JaxoFLine();
        line.setColor(Color.GREEN);
        instance.add(line);
        instance.setColor(color);
        assertEquals(line.getColor(), Color.BLUE);
    }
}
