/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.object;

import java.awt.Dimension;


/**
 * Base Test for JaxoExtendedObjects.
 */
public abstract class AbstractJaxoExtendedObjectTest extends AbstractJaxoObjectTest {
    private JaxoExtendedObject instance;

    /**
     * Constructor.
     *
     * @param testName The name of this test.
     */
    protected AbstractJaxoExtendedObjectTest(String testName) {
        super(testName);
    }

    /** JUnit setup: get a new instance of the object. */
    @Override
    protected void setUp() {
        super.setUp();
        this.instance = (JaxoExtendedObject) getInstance();
    }

    /** Tests isAroundP2. */
    public void testIsAroundP2() {
        instance.setLocation(100, 100, 200, 200);

        assertTrue("Not around P2!",
                instance.isAround(
                JaxoExtendedObject.SELECT_P2, 200, 200, defaultHandle()));
        assertFalse("Is around P2!",
                instance.isAround(
                JaxoExtendedObject.SELECT_P2, 210, 220, defaultHandle()));
    }

    /** Tests latexWidth. */
    public void testLatexWidth() {
        instance.setStrokeWidth(1.f);
        String expected = "\\SetWidth{1.0}";
        String actual = instance.latexWidth();

        assertEquals("Wrong latexWidth!", expected, actual);
    }

    /** Tests latexWidth. */
    public void testRadius() {
        instance.setLocation(100, 100, 200, 100);
        assertEquals(100, instance.getRelw());
        assertEquals(0, instance.getRelh());
        instance.setRadius(200.f);
        assertEquals(200, instance.getRelw());
        assertEquals(0, instance.getRelh());
        Dimension d = instance.getSize();
        assertEquals(200, d.width);
        assertEquals(0, d.height);
    }

    /**
     * Test PathIterator methods for Shape interface.
     */
    public void testPathIterator() {
        assertNotNull(instance.getPathIterator(null));
        assertNotNull(instance.getPathIterator(null, 1.d));
    }

      //
     // abstract
    //

    /** Tests various contains() methods JaxoObject. */
    public abstract void testContains();

    /** Tests various intersect() methods JaxoObject. */
    public abstract void testIntersects();

}
