/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.io.exports;

import java.io.File;

/**
 * Test for JaxoExportPS.
 */
public class JaxoExportPSTest extends AbstractJaxoExportTest {
    private final JaxoExportPS exportPS = new JaxoExportPS(JaxoExportPS.Format.PS);
    private final JaxoExportPS exportEPS = new JaxoExportPS(JaxoExportPS.Format.EPS);

    /** Constructor.
     * @param testName The name of this test.
     */
    public JaxoExportPSTest(String testName) {
        super(testName);
    }

    /**
     * Test of getFileExtension method, of class net.sf.jaxodraw.io.export.JaxoExportPS.
     */
    public void testGetFileExtension() {
        String expResult = "ps";
        String result = exportPS.getFileExtension();
        assertEquals(expResult, result);

        expResult = "eps";
        result = exportEPS.getFileExtension();
        assertEquals(expResult, result);
    }

    /**
     * Test of exportTo method, of class net.sf.jaxodraw.io.export.JaxoExportPS.
     * @throws Exception Exception.
     */
    public void testExportTo() throws Exception {
        File ps = getOutputFile(getBase(), "psExportTest.ps");

        exportPS.setGraph(getTestGraph());
        exportPS.exportTo(ps.getAbsolutePath());

        assertTrue("No ps file created!", ps.exists());
        assertTrue("Empty ps file created!", ps.length() > 0);


        File eps = getOutputFile(getBase(), "epsExportTest.eps");

        exportEPS.setGraph(getTestGraph());
        exportEPS.exportTo(eps.getAbsolutePath());

        assertTrue("No eps file created!", eps.exists());
        assertTrue("Empty eps file created!", eps.length() > 0);
    }

    /** {@inheritDoc} */
    public JaxoExport getInstance() {
        return new JaxoExportPS(JaxoExportPS.Format.EPS);
    }
}
