/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.io.exports;

import java.io.File;

/**
 * Test for JaxoExportLatex.
 */
public class JaxoExportLatexTest extends AbstractJaxoExportTest {
    private final JaxoExportLatex instance = new JaxoExportLatex();

    /** Constructor.
     * @param testName The name of this test.
     */
    public JaxoExportLatexTest(String testName) {
        super(testName);
    }

    /**
     * Test of getFileExtension method, of class net.sf.jaxodraw.io.export.JaxoExportLatex.
     */
    public void testGetFileExtension() {
        String expResult = "tex";
        String result = instance.getFileExtension();
        assertEquals(expResult, result);
    }

    /**
     * Test of exportTo method, of class net.sf.jaxodraw.io.export.JaxoExportLatex.
     * @throws Exception Exception.
     */
    public void testExportTo() throws Exception {
        File tex = getOutputFile(getBase(), "latexExportTest.tex");
        String fileName = tex.getAbsolutePath();

        instance.setGraph(getTestGraph());
        instance.exportTo(fileName);

        assertTrue("No file created!", tex.exists());
        assertTrue("Empty file created!", tex.length() > 0);
    }

    /** {@inheritDoc} */
    public JaxoExport getInstance() {
        return new JaxoExportLatex();
    }
}
