/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.line.JaxoFLine;
import net.sf.jaxodraw.JaxoTestUtils;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoXYREditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoXYREditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoXYREditPanel panel = new JaxoXYREditPanel();
        JSpinner spxin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        JSpinner spyin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        JSpinner sprad = (JSpinner) JaxoTestUtils.getChildNamed(panel, "sprad");
        assertNotNull("No x spinner found!", spxin);
        assertNotNull("No y spinner found!", spyin);
        assertNotNull("No radius spinner found!", sprad);
        SpinnerNumberModel modelx = (SpinnerNumberModel) spxin.getModel();
        SpinnerNumberModel modely = (SpinnerNumberModel) spyin.getModel();
        SpinnerNumberModel modelrad = (SpinnerNumberModel) sprad.getModel();
        int value = modelx.getNumber().intValue();
        assertEquals(200, value);
        value = modely.getNumber().intValue();
        assertEquals(200, value);
        value = modelrad.getNumber().intValue();
        assertEquals(200, value);

        panel = new JaxoXYREditPanel(20, 30, 40);
        spxin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        spyin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        sprad = (JSpinner) JaxoTestUtils.getChildNamed(panel, "sprad");
        modelx = (SpinnerNumberModel) spxin.getModel();
        modely = (SpinnerNumberModel) spyin.getModel();
        modelrad = (SpinnerNumberModel) sprad.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(20, value);
        value = modely.getNumber().intValue();
        assertEquals(30, value);
        value = modelrad.getNumber().intValue();
        assertEquals(40, value);

        JaxoFLine line = new JaxoFLine();
        line.setLocation(0, 0, 3, 4);
        panel = new JaxoXYREditPanel(line.getX(), line.getY(), (int) Math.round(line.length()));

        spxin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxin");
        spyin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyin");
        sprad = (JSpinner) JaxoTestUtils.getChildNamed(panel, "sprad");
        modelx = (SpinnerNumberModel) spxin.getModel();
        modely = (SpinnerNumberModel) spyin.getModel();
        modelrad = (SpinnerNumberModel) sprad.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(0, value);
        value = modely.getNumber().intValue();
        assertEquals(0, value);
        value = modelrad.getNumber().intValue();
        assertEquals(5, value);

        ChangeListener[] listeners = spxin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spyin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = sprad.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(null);
        listeners = spxin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spyin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = sprad.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(line));
        listeners = spxin.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spyin.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = sprad.getChangeListeners();
        assertEquals(2, listeners.length);

        spxin.setValue(new Integer(50));
        spyin.setValue(new Integer(60));
        sprad.setValue(new Integer(5));
        assertEquals(50, line.getX());
        assertEquals(60, line.getY());
        assertEquals(53, line.getX2());
        assertEquals(64, line.getY2());

    }

}
