/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.text.JaxoLatexText;
import net.sf.jaxodraw.JaxoTestUtils;

import javax.swing.JTextArea;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoTextEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoTextEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoTextEditPanel panel = new JaxoTextEditPanel();
        JTextArea tfield = (JTextArea) JaxoTestUtils.getChildNamed(panel, "text");
        assertNotNull("No text textfield found!", tfield);
        assertEquals("", tfield.getText());

        panel = new JaxoTextEditPanel("pifpafpuf");
        tfield = (JTextArea) JaxoTestUtils.getChildNamed(panel, "text");
        assertEquals("pifpafpuf", tfield.getText());

        JaxoLatexText text = new JaxoLatexText();
        text.setTextString("pooohey");

        panel = new JaxoTextEditPanel(text.getTextString());
        tfield = (JTextArea) JaxoTestUtils.getChildNamed(panel, "text");
        assertEquals("pooohey", tfield.getText());


        panel.addEditPanelListener(null);
        panel.addEditPanelListener(new JaxoOptionsPanelListener(text));
        tfield.setText("test");
        assertEquals("test", text.getTextString());

    }

}
