/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.line.JaxoPLine;
import net.sf.jaxodraw.JaxoTestUtils;

import java.awt.event.ItemListener;

import javax.swing.JCheckBox;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoSymmEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoSymmEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoSymmEditPanel panel = new JaxoSymmEditPanel();
        JCheckBox cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "symm");
        assertNotNull("No symm checkbox found!", cbox);
        assertFalse(cbox.isSelected());

        panel = new JaxoSymmEditPanel(true);
        cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "symm");
        assertTrue(cbox.isSelected());

        JaxoPLine line = new JaxoPLine();
        line.setSymmetric(true);

        panel = new JaxoSymmEditPanel(line.isSymmetric());
        cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "symm");
        assertTrue(cbox.isSelected());

        ItemListener[] listeners = cbox.getItemListeners();
        assertEquals(0, listeners.length);
        panel.addEditPanelListener(null);
        listeners = cbox.getItemListeners();
        assertEquals(0, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(line));
        listeners = cbox.getItemListeners();
        assertEquals(1, listeners.length);

        cbox.setSelected(true);
        assertTrue(line.isSymmetric());
        cbox.setSelected(false);
        assertFalse(line.isSymmetric());

    }

}
