/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.bezier.JaxoPBezier;
import net.sf.jaxodraw.JaxoTestUtils;

import java.awt.event.ItemListener;

import javax.swing.JCheckBox;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoStretchingEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoStretchingEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoStretchingEditPanel panel = new JaxoStretchingEditPanel();
        JCheckBox cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "stretch");
        assertNotNull("No stretch checkbox found!", cbox);
        assertFalse(cbox.isSelected());

        panel = new JaxoStretchingEditPanel(true);
        cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "stretch");
        assertTrue(cbox.isSelected());

        JaxoPBezier bezier = new JaxoPBezier();
        bezier.setNoFreqStretching(true);

        panel = new JaxoStretchingEditPanel(bezier.isNoFreqStretching());
        cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "stretch");
        assertTrue(cbox.isSelected());

        ItemListener[] listeners = cbox.getItemListeners();
        assertEquals(0, listeners.length);
        panel.addEditPanelListener(null);
        listeners = cbox.getItemListeners();
        assertEquals(0, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(bezier));
        listeners = cbox.getItemListeners();
        assertEquals(1, listeners.length);

        cbox.setSelected(true);
        assertTrue(bezier.isNoFreqStretching());
        cbox.setSelected(false);
        assertFalse(bezier.isNoFreqStretching());

    }

}
