/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.event.ItemListener;

import javax.swing.JComboBox;

import junit.framework.TestCase;

import net.sf.jaxodraw.object.text.JaxoLatexText;
import net.sf.jaxodraw.JaxoTestUtils;

/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoLatexAlignPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoLatexAlignPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoLatexAlignPanel panel = new JaxoLatexAlignPanel();
        JComboBox cbox = (JComboBox) JaxoTestUtils.getChildNamed(panel, "latexalign");
        assertNotNull("No latexalign combobox found!", cbox);
        assertEquals(4, cbox.getSelectedIndex());


        JaxoLatexText text = new JaxoLatexText();
        text.setAllign(JaxoLatexText.ALIGN_CB);

        panel = new JaxoLatexAlignPanel(text.getAllign());
        cbox = (JComboBox) JaxoTestUtils.getChildNamed(panel, "latexalign");
        assertEquals(5, cbox.getSelectedIndex());

        ItemListener[] listeners = cbox.getItemListeners();
        assertTrue(listeners.length > 0);
        // this passes on Windows and Linux, but fails on Mac
        // compile once, run everywhere,... my foot
        //assertEquals(1, listeners.length);
        panel.addEditPanelListener(null);
        listeners = cbox.getItemListeners();
        //assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(text));
        listeners = cbox.getItemListeners();
        //assertEquals(2, listeners.length);

        cbox.setSelectedIndex(3);
        assertEquals(3, text.getAllign());

    }

}
