/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.line.JaxoFLine;
import net.sf.jaxodraw.JaxoTestUtils;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoDashEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoDashEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoDashEditPanel panel = new JaxoDashEditPanel();
        JSpinner spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "dash");
        assertNotNull("No dash spinner found!", spinner);
        SpinnerNumberModel model = (SpinnerNumberModel) spinner.getModel();
        float value = Math.abs(model.getNumber().floatValue());
        assertEquals(1.f, value, 0.001f);

        panel = new JaxoDashEditPanel(0.2f);
        spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "dash");
        model = (SpinnerNumberModel) spinner.getModel();
        value = Math.abs(model.getNumber().floatValue());
        assertEquals(0.2f, value, 0.001f);

        JaxoFLine line = new JaxoFLine();
        line.setLocation(10, 10, 20, 20);
        line.setPaintArrow(true);
        line.setDash(0.9f);

        panel = new JaxoDashEditPanel(line.getDash());
        spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "dash");
        model = (SpinnerNumberModel) spinner.getModel();
        value = Math.abs(model.getNumber().floatValue());
        assertEquals(0.9f, value, 0.001f);

        ChangeListener[] listeners = spinner.getChangeListeners();
        assertEquals(1, listeners.length);
        panel.addEditPanelListener(null);
        listeners = spinner.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(line));
        listeners = spinner.getChangeListeners();
        assertEquals(2, listeners.length);

        spinner.setValue(new Double(0.66f));
        assertEquals(0.66f, line.getDash(), 0.001f);

    }

}
