/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import net.sf.jaxodraw.object.line.JaxoFLine;
import net.sf.jaxodraw.JaxoTestUtils;

import java.awt.event.ItemListener;

import javax.swing.JCheckBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class JaxoDLEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoDLEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        JaxoDLEditPanel panel = new JaxoDLEditPanel();
        JSpinner spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "dlsep");
        assertNotNull("No dlsep spinner found!", spinner);
        SpinnerNumberModel model = (SpinnerNumberModel) spinner.getModel();
        float value = model.getNumber().floatValue();
        assertEquals(1.f, value, 0.001f);
        JCheckBox cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "dLine");
        assertNotNull("No symm checkbox found!", cbox);
        assertFalse(cbox.isSelected());

        panel = new JaxoDLEditPanel(true, 3.5f);
        spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "dlsep");
        model = (SpinnerNumberModel) spinner.getModel();
        value = model.getNumber().floatValue();
        assertEquals(3.5f, value, 0.001f);
        cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "dLine");
        assertTrue(cbox.isSelected());

        JaxoFLine line = new JaxoFLine();
        line.setLocation(10, 10, 20, 20);
        line.setDLSeparation(5.2f);
        line.setDoubleLine(true);

        panel = new JaxoDLEditPanel(line.isDoubleLine(), line.getDLSeparation());
        spinner = (JSpinner) JaxoTestUtils.getChildNamed(panel, "dlsep");
        model = (SpinnerNumberModel) spinner.getModel();
        value = model.getNumber().floatValue();
        assertEquals(5.2f, value, 0.001f);
        cbox = (JCheckBox) JaxoTestUtils.getChildNamed(panel, "dLine");
        assertTrue(cbox.isSelected());

        ChangeListener[] listeners = spinner.getChangeListeners();
        ItemListener[] ilisteners = cbox.getItemListeners();
        assertEquals(1, listeners.length);
        assertEquals(1, ilisteners.length);
        panel.addEditPanelListener(null);
        listeners = spinner.getChangeListeners();
        ilisteners = cbox.getItemListeners();
        assertEquals(1, listeners.length);
        assertEquals(1, ilisteners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(line));
        listeners = spinner.getChangeListeners();
        assertEquals(2, listeners.length);
        ilisteners = cbox.getItemListeners();
        assertEquals(2, ilisteners.length);

        spinner.setValue(new Double(1.3f));
        cbox.setSelected(true);
        assertEquals(1.3f, line.getDLSeparation(), 0.001f);
        assertTrue(line.isDoubleLine());
        cbox.setSelected(false);
        assertFalse(line.isDoubleLine());

    }

}
