/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.edit;

import java.awt.Point;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

import junit.framework.TestCase;

import net.sf.jaxodraw.object.line.JaxoFLine;
import net.sf.jaxodraw.JaxoTestUtils;


/** Tests methods in JaxoEditPanel using JaxoFArc as instance. */
public class Jaxo2PointsEditPanelTest extends TestCase {

    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public Jaxo2PointsEditPanelTest(String testName) {
        super(testName);
    }

    /** Tests constructors. */
    public void testConstructors() {
        Jaxo2PointsEditPanel panel = new Jaxo2PointsEditPanel();
        JSpinner spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx");
        JSpinner spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy");
        JSpinner spxfin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxfin");
        JSpinner spyfin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyfin");
        assertNotNull("No x1 spinner found!", spx);
        assertNotNull("No y1 spinner found!", spy);
        assertNotNull("No x2 spinner found!", spxfin);
        assertNotNull("No y2 spinner found!", spyfin);
        SpinnerNumberModel modelx = (SpinnerNumberModel) spx.getModel();
        SpinnerNumberModel modely = (SpinnerNumberModel) spy.getModel();
        SpinnerNumberModel modelxfin = (SpinnerNumberModel) spxfin.getModel();
        SpinnerNumberModel modelyfin = (SpinnerNumberModel) spyfin.getModel();
        int value = modelx.getNumber().intValue();
        assertEquals(0, value);
        value = modely.getNumber().intValue();
        assertEquals(0, value);
        value = modelxfin.getNumber().intValue();
        assertEquals(0, value);
        value = modelyfin.getNumber().intValue();
        assertEquals(0, value);

        Point p1 = new Point(20, 30);
        Point p2 = new Point(40, 50);
        panel = new Jaxo2PointsEditPanel(new Point[] {p1, p2});
        spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx");
        spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy");
        spxfin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxfin");
        spyfin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyfin");
        modelx = (SpinnerNumberModel) spx.getModel();
        modely = (SpinnerNumberModel) spy.getModel();
        modelxfin = (SpinnerNumberModel) spxfin.getModel();
        modelyfin = (SpinnerNumberModel) spyfin.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(20, value);
        value = modely.getNumber().intValue();
        assertEquals(30, value);
        value = modelxfin.getNumber().intValue();
        assertEquals(40, value);
        value = modelyfin.getNumber().intValue();
        assertEquals(50, value);

        JaxoFLine line = new JaxoFLine();
        line.setLocation(10, 50, 20, 60);
        p1.setLocation(line.getX(), line.getY());
        p2.setLocation(line.getX2(), line.getY2());
        panel = new Jaxo2PointsEditPanel(new Point[] {p1, p2});

        spx = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spx");
        spy = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spy");
        spxfin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spxfin");
        spyfin = (JSpinner) JaxoTestUtils.getChildNamed(panel, "spyfin");
        modelx = (SpinnerNumberModel) spx.getModel();
        modely = (SpinnerNumberModel) spy.getModel();
        modelxfin = (SpinnerNumberModel) spxfin.getModel();
        modelyfin = (SpinnerNumberModel) spyfin.getModel();
        value = modelx.getNumber().intValue();
        assertEquals(10, value);
        value = modely.getNumber().intValue();
        assertEquals(50, value);
        value = modelxfin.getNumber().intValue();
        assertEquals(20, value);
        value = modelyfin.getNumber().intValue();
        assertEquals(60, value);

        ChangeListener[] listeners = spx.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spxfin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spyfin.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(null);
        listeners = spx.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spxfin.getChangeListeners();
        assertEquals(1, listeners.length);
        listeners = spyfin.getChangeListeners();
        assertEquals(1, listeners.length);

        panel.addEditPanelListener(new JaxoOptionsPanelListener(line));
        listeners = spx.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spy.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spxfin.getChangeListeners();
        assertEquals(2, listeners.length);
        listeners = spyfin.getChangeListeners();
        assertEquals(2, listeners.length);

        spx.setValue(new Integer(50));
        spy.setValue(new Integer(150));
        spxfin.setValue(new Integer(250));
        spyfin.setValue(new Integer(350));
        assertEquals(50, line.getX());
        assertEquals(150, line.getY());
        assertEquals(250, line.getX2());
        assertEquals(350, line.getY2());

    }

}
