/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.panel.button;

import junit.framework.TestCase;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

/** Tests for JaxoPanelButton. */
public class JaxoPanelButtonTest extends TestCase {
    /** Constructor: just calls super().
     * @param testName The name of this test.
     */
    public JaxoPanelButtonTest(String testName) {
        super(testName);
    }

    /**
     * Test of colors and borders method, of class JaxoDraw.JaxoPanelButton.
       This tests a lot of the implementation (JaxoPanelButton does not document
       that it uses these Borders, Colors or CompoundBorder to implement the
       default mode.
     */
    public void testColorsAndBorders() {
        Color pressedBackground = new Color(170, 170, 180);
        Border unpressedBorder = BorderFactory.createRaisedBevelBorder();
        Border pressedBorder = BorderFactory.createLoweredBevelBorder();

        JaxoPanelButton instance = new JaxoPanelButton();

        assertFalse(instance.isDefault());
        instance.setDefault(false);
        assertFalse(instance.isDefault());
        assertEquals(unpressedBorder, instance.getBorder());
        instance.setSelected(true);
        assertEquals(pressedBackground, instance.getBackground());
        assertEquals(pressedBorder, instance.getBorder());
        instance.setDefault(true);
        assertTrue(instance.isDefault());
        assertTrue(instance.getBorder() instanceof CompoundBorder);
        instance.setSelected(false);
        assertTrue(instance.getBorder() instanceof CompoundBorder);
        instance.setSelected(false);
        instance.setDefault(true);
        assertTrue(instance.getBorder() instanceof CompoundBorder);
    }

    /**
     * Test of setId method, of class JaxoDraw.JaxoPanelButton.
     */
    public void testSetId() {
        JaxoPanelButton instance = new JaxoPanelButton();
        String id = "an_incredibly_stupid_id";
        instance.setId(id);
        assertEquals("setId() should set name",
            id, instance.getName());
        assertEquals("setId() should set actionCommand",
            id, instance.getActionCommand());
    }

}
