/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */
package net.sf.jaxodraw.gui.menu;


import net.sf.jaxodraw.util.JaxoConstants;

/**
 * Test of JaxoEditMenu.
 */
public class JaxoEditMenuTest extends AbstractMenuBarTest {

    /**
     * Constructor.
     *
     * @param testName name of the test.
     */
    public JaxoEditMenuTest(String testName) {
        super(testName);
    }

    /**
     * Test Undo menu item.
     */
    public void testUndo() {
        assertEnabled(JaxoConstants.UNDO, "Jaxo.canUndo");
    }

    /**
     * Test Redo menu item.
     */
    public void testRedo() {
        assertEnabled(JaxoConstants.REDO, "Jaxo.canRedo");
    }

    /**
     * Test Clear menu item.
     */
    public void testClear() {
        assertAction(JaxoConstants.CLEAR);
    }

    /**
     * Test Paste menu item.
     */
    public void testPaste() {
        assertAction(JaxoConstants.PASTE);
    }

    /**
     * Test Refresh menu item.
     */
    public void testRefresh() {
        assertAction(JaxoConstants.REFRESH);
    }

    /**
     * Test Move menu item.
     */
    public void testMove() {
        assertAction(JaxoConstants.MOVE);
    }

    /**
     * Test Resize menu item.
     */
    public void testResize() {
        assertAction(JaxoConstants.RESIZE);
    }

    /**
     * Test Duplicate menu item.
     */
    public void testDuplicate() {
        assertAction(JaxoConstants.DUPLICATE);
    }

    /**
     * Test Color menu item.
     */
    public void testColor() {
        assertAction(JaxoConstants.COLOR);
    }

    /**
     * Test Edit menu item.
     */
    public void testEdit() {
        assertAction(JaxoConstants.EDIT);
    }

    /**
     * Test Delete menu item.
     */
    public void testDelete() {
        assertAction(JaxoConstants.DELETE);
    }

    /**
     * Test Background menu item.
     */
    public void testBackground() {
        assertAction(JaxoConstants.BACKGROUND);
    }

    /**
     * Test Foreground menu item.
     */
    public void testForeground() {
        assertAction(JaxoConstants.FOREGROUND);
    }

    /**
     * Test Select menu item.
     */
    public void testSelect() {
        assertAction(JaxoConstants.SELECT);
    }

    /**
     * Test Ungroup menu item.
     */
    public void testUngroup() {
        assertAction(JaxoConstants.UNGROUP);
    }

    /**
     * Test Zoom menu item.
     */
    public void testZoom() {
        assertAction(JaxoConstants.ZOOM);
    }

    /** {@inheritDoc} */
    public void assertSetup() {
        // nop
    }

    /** {@inheritDoc} */
    public void assertLanguage() {
        // nop
    }

}
