/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.gui.handle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

import net.sf.jaxodraw.AbstractJaxoBaseTest;

/**
 * Test of AbstractJaxoHandleTest.java.
 */
public abstract class AbstractJaxoHandleTest extends AbstractJaxoBaseTest {

    /**
     * Constructor.
     *
     * @param testName name of the test.
     */
    public AbstractJaxoHandleTest(String testName) {
        super(testName);
    }

    /**
     * Test of set/getColor method, of class AbstractJaxoHandle.
     */
    public void testGetSetColor() {
        AbstractJaxoHandle instance = getInstance();
        instance.setColor(null);
        assertNull(instance.getColor());

        instance.setColor(Color.BLUE);
        assertEquals(Color.BLUE, instance.getColor());
    }

    /**
     * Test of get/setFillColor method, of class AbstractJaxoHandle.
     */
    public void testGetSetFillColor() {
        AbstractJaxoHandle instance = getInstance();
        instance.setFillColor(null);
        assertNull(instance.getFillColor());

        instance.setFillColor(Color.BLUE);
        assertEquals(Color.BLUE, instance.getFillColor());
    }

    /**
     * Test of get/setSecondaryColor method, of class AbstractJaxoHandle.
     */
    public void testGetSetSecondaryColor() {
        AbstractJaxoHandle instance = getInstance();
        instance.setSecondaryColor(null);
        assertNull(instance.getSecondaryColor());

        instance.setSecondaryColor(Color.BLUE);
        assertEquals(Color.BLUE, instance.getSecondaryColor());
    }

    /**
     * Test of get/setSize method, of class AbstractJaxoHandle.
     */
    public void testGetSetSize() {
        AbstractJaxoHandle instance = getInstance();
        instance.setSize(0);
        assertTrue(instance.getSize() == 0);

        instance.setSize(5);
        assertTrue(instance.getSize() == 5);
    }

    /**
     * Test of get/setStroke method, of class AbstractJaxoHandle.
     */
    public void testGetSetStroke() {
        AbstractJaxoHandle instance = getInstance();
        instance.setStroke(null);
        assertNull(instance.getStroke());
        Stroke stroke = new BasicStroke();

        instance.setStroke(stroke);
        assertEquals(stroke, instance.getStroke());
    }


    /**
     * Return an implementation of AbstractJaxoHandle.
     *
     * @return an AbstractJaxoHandle.
     */
    public abstract AbstractJaxoHandle getInstance();

}
