/**
 *  Licensed under GPL. For more information, see
 *    http://jaxodraw.sourceforge.net/license.html
 *  or the LICENSE file in the jaxodraw distribution.
 */

package net.sf.jaxodraw.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.grid.JaxoPaintableGrid;

/**
 * A canvas used for testing.
 */
public class JaxoTestCanvas implements JaxoDrawingArea {

    private String lastEvent;

    /**
     * Get the last notified event.
     *
     * @return the last notified event or null if none.
     */
    public String getLastEvent() {
        return lastEvent;
    }

    /**
     * Reset the last notified event to null.
     */
    public void clearLastEvent() {
        this.lastEvent = null;
    }

    /** {@inheritDoc} */
    public void clear() {
        this.lastEvent = "clear";
    }

    /** {@inheritDoc} */
    public void continueEdit(Point p, Point last) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void continueSelect(Point p) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void copyMarkedObjects() {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void cutMarkedObjects() {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void editNearestObject(Point p) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void finalizeEdit() {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void finalizeSelect(Point p) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public JaxoGraph getClipboard() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public JaxoZoom getZoom() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public void groupMarkedObjects() {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void initiateEdit(Point p) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void initiateSelect(Point p) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void markImageInvalid(Rectangle boundingBox) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void moveSelection(boolean backGround) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void moveGraph(int dx, int dy) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void pasteFromClipboard() {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void refresh() {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void setCanvasGraph(JaxoGraph value) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void setGrid(JaxoPaintableGrid value) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void ungroupMarkedObjects() {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public boolean unMarkGraph() {
        this.lastEvent = "";
        return false;
    }

    /** {@inheritDoc} */
    public void updatePointsAid(Point p) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void addMouseListener(MouseListener l) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void addMouseMotionListener(MouseMotionListener l) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public Component asComponent() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public Color getCanvasBackground() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public Rectangle getCanvasBounds() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public Point getCanvasOrigin() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public Dimension getCanvasSize() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public Graphics getGraphics() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public Dimension getMaximumCanvasSize() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public Dimension getMinimumCanvasSize() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public void print(Graphics g) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void removeMouseListener(MouseListener l) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void removeMouseMotionListener(MouseMotionListener l) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void repaint() {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void setCanvasBackground(Color color) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void setMaximumCanvasSize(Dimension value) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void setMinimumCanvasSize(Dimension value) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public void propertyChange(PropertyChangeEvent evt) {
        this.lastEvent = "";
    }

    /** {@inheritDoc} */
    public Dimension getPreferredScrollableViewportSize() {
        this.lastEvent = "";
        return null;
    }

    /** {@inheritDoc} */
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        this.lastEvent = "";
        return 0;
    }

    /** {@inheritDoc} */
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        this.lastEvent = "";
        return 0;
    }

    /** {@inheritDoc} */
    public boolean getScrollableTracksViewportWidth() {
        this.lastEvent = "";
        return false;
    }

    /** {@inheritDoc} */
    public boolean getScrollableTracksViewportHeight() {
        this.lastEvent = "";
        return false;
    }

    /** {@inheritDoc} */
    public void updateLanguage() {
        this.lastEvent = "";
    }
}
